/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.modelio;

public class Version {
    private int buildVersion;
    private int majorVersion;
    private int metamodelVersion;
    private int minorVersion;

    public Version(int n, int n2, int n3, int n4) {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.buildVersion = n3;
        this.metamodelVersion = n4;
    }

    public Version(String string) throws NumberFormatException {
        String[] stringArray = string.split("\\.", 4);
        this.majorVersion = stringArray.length > 0 && stringArray[0].length() != 0 ? Integer.parseInt(stringArray[0]) : 0;
        this.minorVersion = stringArray.length > 1 && stringArray[1].length() != 0 ? Integer.parseInt(stringArray[1]) : 0;
        this.buildVersion = stringArray.length > 2 && stringArray[2].length() != 0 ? this.parseRevision(stringArray[2]) : 0;
        this.metamodelVersion = stringArray.length > 3 && stringArray[3].length() != 0 ? Integer.parseInt(stringArray[3]) : 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Version) {
            Version version = (Version)object;
            return this.majorVersion == version.majorVersion && this.minorVersion == version.minorVersion && this.buildVersion == version.buildVersion && this.metamodelVersion == version.metamodelVersion;
        }
        return false;
    }

    public int getBuildVersion() {
        return this.buildVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMetamodelVersion() {
        return this.metamodelVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean isNewerThan(Version version) {
        if (this.majorVersion < version.majorVersion) {
            return false;
        }
        if (this.majorVersion > version.majorVersion) {
            return true;
        }
        if (this.minorVersion < version.minorVersion) {
            return false;
        }
        if (this.minorVersion > version.minorVersion) {
            return true;
        }
        if (this.buildVersion < version.buildVersion) {
            return false;
        }
        if (this.buildVersion > version.buildVersion) {
            return true;
        }
        if (this.metamodelVersion < version.metamodelVersion) {
            return false;
        }
        return this.metamodelVersion > version.metamodelVersion;
    }

    public boolean isOlderThan(Version version) {
        if (this.majorVersion > version.majorVersion) {
            return false;
        }
        if (this.majorVersion < version.majorVersion) {
            return true;
        }
        if (this.minorVersion > version.minorVersion) {
            return false;
        }
        if (this.minorVersion < version.minorVersion) {
            return true;
        }
        if (this.buildVersion > version.buildVersion) {
            return false;
        }
        if (this.buildVersion < version.buildVersion) {
            return true;
        }
        if (this.metamodelVersion > version.metamodelVersion) {
            return false;
        }
        return this.metamodelVersion < version.metamodelVersion;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.majorVersion);
        stringBuffer.append('.');
        stringBuffer.append(this.minorVersion);
        stringBuffer.append('.');
        stringBuffer.append(String.format("%02d", this.buildVersion));
        stringBuffer.append('.');
        stringBuffer.append(this.metamodelVersion);
        return stringBuffer.toString();
    }

    private int parseRevision(String string) throws NumberFormatException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(string, 36);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.buildVersion;
        n = 31 * n + this.majorVersion;
        n = 31 * n + this.metamodelVersion;
        n = 31 * n + this.minorVersion;
        return n;
    }
}

