/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui;

import com.modeliosoft.modelio.api.ui.IModelioDialog;
import org.eclipse.jface.dialogs.ControlAnimator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ImageAndMessageArea;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class ModelioDialog
extends TrayDialog
implements IModelioDialog {
    public static final String DLG_IMG_TITLE_BANNER = "dialog_title_banner_image";
    private static final int MIN_DIALOG_HEIGHT = 250;
    private static final int MIN_DIALOG_WIDTH = 350;
    Color titleAreaColor;
    private ControlAnimator animator;
    private String errorMessage;
    private Label leftFillerLabel;
    private String message = "";
    private ImageAndMessageArea messageArea;
    private Image messageImage;
    private Label messageImageLabel;
    private Text messageLabel;
    private int messageLabelHeight;
    private boolean showingError = false;
    private boolean showingWarning = false;
    private Composite titleArea;
    private RGB titleAreaRGB;
    private boolean titleImageLargest = true;
    private Label titleLabel;
    private Image titleLeftImage;
    private Label titleLeftImageLabel;
    private Image titleRightImage;
    private Label titleRightImageLabel;
    private String warningMessage;
    private Composite workArea;

    protected ModelioDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10870 | ModelioDialog.getDefaultOrientation());
        this.setBlockOnOpen(true);
    }

    protected void addDefaultButtons(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.addButtonsInButtonBar(composite);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)composite2);
        FormLayout formLayout = new FormLayout();
        composite2.setLayout((Layout)formLayout);
        this.workArea = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.workArea.setLayout((Layout)gridLayout);
        Control control = this.createTitleArea(composite2);
        this.resetWorkAreaAttachments(control);
        this.workArea.setFont(JFaceResources.getDialogFont());
        this.initializeDialogUnits((Control)this.workArea);
        this.dialogArea = this.createDialogArea(this.workArea);
        this.buttonBar = this.createButtonBar(this.workArea);
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.ui", (String)"icons/headerLeft.png");
        Image image = imageDescriptor.createImage();
        this.setTitleLeftImage(image);
        this.init();
        return composite2;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 258);
        this.initHelpButton((Control)composite2);
        this.createContentArea(composite2);
        label.setLayoutData((Object)new GridData(768));
        return composite2;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(350), point.x), Math.max(this.convertVerticalDLUsToPixels(250), point.y));
    }

    protected void setErrorMessage(String string) {
        if (this.errorMessage != null ? this.errorMessage.equals(string) : string == null) {
            return;
        }
        this.errorMessage = string;
        if (this.errorMessage == null) {
            if (this.messageArea != null && !this.showingWarning) {
                this.setMessageAreaVisible(false);
            }
            if (this.showingError) {
                this.showingError = false;
            }
            if (this.message == null) {
                this.message = "";
            }
            this.updateMessage(this.message);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
            if (this.showingWarning) {
                this.setWarningMessage(this.warningMessage);
            }
        } else {
            if (!this.showingError) {
                this.showingError = true;
            }
            if (this.showingWarning) {
                this.setWarningMessage(null);
            }
            if (this.messageArea == null) {
                this.messageArea = new ImageAndMessageArea(this.titleArea, 64);
                this.messageArea.setBackground(this.messageLabel.getBackground());
                this.animator = Policy.getAnimatorFactory().createAnimator((Control)this.messageArea);
            }
            this.messageArea.setToolTipText(this.errorMessage);
            this.messageArea.setText(this.errorMessage);
            this.messageArea.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
            this.setMessageAreaVisible(true);
        }
        int n = this.convertVerticalDLUsToPixels(1);
        int n2 = this.convertHorizontalDLUsToPixels(4);
        this.setLayoutsForNormalMessage(n, n2);
    }

    protected void setLogoImage(Image image) {
        this.titleRightImage = image;
        if (this.titleRightImageLabel != null && !this.titleRightImageLabel.isDisposed()) {
            this.titleRightImageLabel.setImage(image);
            this.titleRightImageLabel.setVisible(image != null);
            if (image != null) {
                this.resetWorkAreaAttachments((Control)this.titleArea);
            }
        }
    }

    protected void setMessage(String string) {
        this.setMessage(string, 0);
    }

    protected void setTitle(String string) {
        if (this.titleLabel == null) {
            return;
        }
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        this.titleLabel.setText(string2);
    }

    protected void setTitleLeftImage(Image image) {
        this.titleLeftImage = image;
        if (this.titleLeftImageLabel != null && !this.titleLeftImageLabel.isDisposed()) {
            this.titleLeftImageLabel.setImage(image);
            this.titleLeftImageLabel.setVisible(image != null);
            if (image != null) {
                this.resetWorkAreaAttachments((Control)this.titleArea);
            }
        }
    }

    protected void setWarningMessage(String string) {
        if (this.warningMessage != null ? this.warningMessage.equals(string) : string == null) {
            return;
        }
        this.warningMessage = string;
        if (this.warningMessage == null) {
            if (this.messageArea != null && !this.showingError) {
                this.setMessageAreaVisible(false);
            }
            if (this.showingWarning) {
                this.showingWarning = false;
            }
        } else {
            if (!this.showingWarning) {
                this.showingWarning = true;
            }
            this.warningMessage = string;
            if (this.messageArea == null) {
                this.messageArea = new ImageAndMessageArea(this.titleArea, 64);
                this.messageArea.setBackground(this.messageLabel.getBackground());
                this.animator = Policy.getAnimatorFactory().createAnimator((Control)this.messageArea);
            }
            this.messageArea.setToolTipText(this.warningMessage);
            this.messageArea.setText(this.warningMessage);
            this.messageArea.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
            this.setMessageAreaVisible(true);
        }
        int n = this.convertVerticalDLUsToPixels(1);
        int n2 = this.convertHorizontalDLUsToPixels(4);
        this.setLayoutsForNormalMessage(n, n2);
    }

    private Control createTitleArea(Composite composite) {
        Color color;
        Color color2;
        this.titleArea = new Composite(composite, 0);
        this.initializeDialogUnits((Control)this.titleArea);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.titleArea.setLayoutData((Object)formData);
        FormLayout formLayout = new FormLayout();
        this.titleArea.setLayout((Layout)formLayout);
        this.titleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ModelioDialog.this.titleAreaColor != null) {
                    ModelioDialog.this.titleAreaColor.dispose();
                }
            }
        });
        Display display = this.titleArea.getDisplay();
        if (this.titleAreaRGB != null) {
            color2 = this.titleAreaColor = new Color((Device)display, this.titleAreaRGB);
            color = null;
        } else {
            color2 = JFaceColors.getBannerBackground((Display)display);
            color = JFaceColors.getBannerForeground((Display)display);
        }
        int n = this.convertVerticalDLUsToPixels(1);
        int n2 = this.convertHorizontalDLUsToPixels(4);
        this.titleArea.setBackground(color2);
        this.titleRightImageLabel = new Label(this.titleArea, 0);
        this.titleRightImageLabel.setBackground(color2);
        if (this.titleRightImage != null && !this.titleRightImage.isDisposed()) {
            this.titleRightImageLabel.setImage(this.titleRightImage);
        }
        this.titleLeftImageLabel = new Label(this.titleArea, 0);
        this.titleLeftImageLabel.setBackground(color2);
        if (this.titleLeftImage == null || this.titleLeftImage.isDisposed()) {
            this.titleLeftImageLabel.setImage(JFaceResources.getImage((String)DLG_IMG_TITLE_BANNER));
        } else {
            this.titleLeftImageLabel.setImage(this.titleLeftImage);
        }
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        this.titleRightImageLabel.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment(0, 0);
        formData3.left = new FormAttachment(0, 0);
        this.titleLeftImageLabel.setLayoutData((Object)formData3);
        this.titleLabel = new Label(this.titleArea, 0);
        JFaceColors.setColors((Control)this.titleLabel, (Color)color, (Color)color2);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.titleLabel.setText(" ");
        FormData formData4 = new FormData();
        formData4.left = new FormAttachment((Control)this.titleLeftImageLabel, 5);
        formData4.top = new FormAttachment(0, n);
        formData4.right = new FormAttachment((Control)this.titleRightImageLabel, -5);
        this.titleLabel.setLayoutData((Object)formData4);
        this.messageImageLabel = new Label(this.titleArea, 0);
        this.messageImageLabel.setBackground(color2);
        this.messageLabel = new Text(this.titleArea, 74);
        this.messageLabel.setEnabled(false);
        this.messageLabel.setEditable(false);
        JFaceColors.setColors((Control)this.messageLabel, (Color)color, (Color)color2);
        this.messageLabel.setFont(JFaceResources.getDialogFont());
        this.messageLabelHeight = this.messageLabel.computeSize((int)-1, (int)-1).y;
        this.leftFillerLabel = new Label(this.titleArea, 0);
        this.leftFillerLabel.setBackground(color2);
        this.setLayoutsForNormalMessage(n, n2);
        this.determineTitleImageLargest();
        return this.titleArea;
    }

    private void determineTitleImageLargest() {
        int n = this.titleLeftImageLabel.computeSize((int)-1, (int)-1).y;
        int n2 = this.convertVerticalDLUsToPixels(1);
        int n3 = this.titleLabel.computeSize((int)-1, (int)-1).y;
        n3 += n2;
        n3 += this.messageLabelHeight;
        this.titleImageLargest = n > (n3 += n2);
    }

    private void layoutForNewMessage() {
        int n = this.convertVerticalDLUsToPixels(1);
        int n2 = this.convertHorizontalDLUsToPixels(4);
        this.setLayoutsForNormalMessage(n, n2);
        if (this.dialogArea != null) {
            this.titleArea.layout(true);
        }
    }

    private void resetWorkAreaAttachments(Control control) {
        FormData formData = new FormData();
        formData.top = new FormAttachment(control);
        formData.right = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.workArea.setLayoutData((Object)formData);
    }

    private void setImageLabelVisible(boolean bl) {
        this.messageImageLabel.setVisible(bl);
        this.leftFillerLabel.setVisible(bl);
    }

    private void setLayoutsForNormalMessage(int n, int n2) {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.titleLabel, n);
        formData.right = new FormAttachment((Control)this.titleRightImageLabel);
        formData.left = new FormAttachment((Control)this.messageImageLabel, n2);
        if (!this.titleImageLargest) {
            formData.bottom = new FormAttachment((Control)this.titleRightImageLabel, 0, 1024);
        }
        this.messageLabel.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.titleLabel, n);
        formData2.left = new FormAttachment((Control)this.titleLeftImageLabel);
        this.messageImageLabel.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment((Control)this.titleLabel, 0, 128);
        formData3.left = new FormAttachment((Control)this.titleLeftImageLabel);
        formData3.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
        this.leftFillerLabel.setLayoutData((Object)formData3);
    }

    protected void setMessage(String string, int n) {
        Image image = null;
        if (string != null) {
            switch (n) {
                case 1: {
                    image = JFaceResources.getImage((String)"dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    image = JFaceResources.getImage((String)"dialog_message_error_image");
                }
            }
        }
        if (n == 2) {
            this.setWarningMessage(string);
        } else {
            this.setWarningMessage(null);
            this.showMessage(string, image);
        }
    }

    private void setMessageAreaVisible(boolean bl) {
        this.messageArea.moveAbove(null);
        int n = this.titleArea.getBounds().y + this.titleArea.getBounds().height;
        Rectangle rectangle = this.messageLabel.getBounds();
        if (!this.messageArea.isVisible() && this.messageArea.getBounds().y != n) {
            this.messageArea.setBounds(this.messageImageLabel != null ? this.messageImageLabel.getBounds().x : rectangle.x, n, this.messageImageLabel != null ? rectangle.width + this.messageImageLabel.getBounds().width : rectangle.width, this.messageArea.computeSize((int)-1, (int)-1).y);
        }
        this.animator.setVisible(bl);
        this.setMessageLayoutData();
    }

    private void setMessageLayoutData() {
        if (this.messageArea == null) {
            return;
        }
        FormData formData = new FormData();
        formData.right = new FormAttachment((Control)this.titleRightImageLabel);
        formData.left = new FormAttachment((Control)this.leftFillerLabel);
        formData.bottom = new FormAttachment(100, 0);
        this.messageArea.setLayoutData((Object)formData);
    }

    private void showMessage(String string, Image image) {
        if (this.message.equals(string) && this.messageImage == image) {
            return;
        }
        this.message = string;
        if (this.message == null) {
            this.message = "";
        }
        String string2 = this.message;
        this.messageImage = image;
        if (!this.showingError) {
            this.updateMessage(string2);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
            this.layoutForNewMessage();
        }
    }

    private void updateMessage(String string) {
        this.messageLabel.setText(string);
    }

    private void initHelpButton(Control control) {
        String string = this.getHelpId();
        if (string != null) {
            this.setHelpAvailable(true);
            control.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent helpEvent) {
                    String string = ModelioDialog.this.getHelpId();
                    if (string != null) {
                        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
                    }
                }
            });
        }
    }

    protected String getHelpId() {
        return null;
    }

    public void setBlockOnOpen(boolean bl) {
        if (!bl) {
            int n = this.getShellStyle();
            this.setShellStyle(n &= 0xFFFC7FFF);
        }
        super.setBlockOnOpen(bl);
    }
}

