/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui;

import com.modeliosoft.modelio.api.ui.ModelioDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ModelioWizardDialog
extends ModelioDialog
implements IWizardContainer2,
IPageChangeProvider {
    public static final String WIZ_IMG_ERROR = "dialog_title_error_image";
    private IWizard wizard;
    private List<IWizard> createdWizards = new ArrayList<IWizard>();
    private List<IWizard> nestedWizards = new ArrayList<IWizard>();
    private IWizardPage currentPage = null;
    private long activeRunningOperations = 0L;
    private long timeWhenLastJobFinished = -1L;
    private boolean useCustomProgressMonitorPart = true;
    private int pageMessageType = 0;
    private String pageDescription;
    private ProgressMonitorPart progressMonitorPart;
    private Cursor waitCursor;
    private Cursor arrowCursor;
    private MessageDialog windowClosingDialog;
    private Button backButton;
    private Button nextButton;
    private Button finishButton;
    private Button cancelButton;
    private Button helpButton;
    private SelectionAdapter cancelListener;
    private boolean isMovingToPreviousPage = false;
    private Composite pageContainer;
    private PageContainerFillLayout pageContainerLayout = new PageContainerFillLayout(5, 5, 300, 225);
    private int pageWidth = -1;
    private int pageHeight = -1;
    private static final String FOCUS_CONTROL = "focusControl";
    private static final int RESTORE_ENTER_DELAY = 500;
    private boolean lockedUI = false;
    private ListenerList pageChangedListeners = new ListenerList();
    private ListenerList pageChangingListeners = new ListenerList();

    public ModelioWizardDialog(Shell shell, IWizard iWizard) {
        super(shell);
        this.setShellStyle(0x10C70 | ModelioWizardDialog.getDefaultOrientation());
        this.setWizard(iWizard);
        this.cancelListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ModelioWizardDialog.this.cancelPressed();
            }
        };
    }

    private Object aboutToStart(boolean bl) {
        Map map = null;
        if (this.getShell() != null) {
            Control control = this.getShell().getDisplay().getFocusControl();
            if (control != null && control.getShell() != this.getShell()) {
                control = null;
            }
            boolean bl2 = this.wizard.needsProgressMonitor();
            Display display = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)display, 1);
            this.setDisplayCursor(this.waitCursor);
            if (this.useCustomProgressMonitorPart) {
                this.cancelButton.removeSelectionListener((SelectionListener)this.cancelListener);
                this.arrowCursor = new Cursor((Device)display, 0);
                this.cancelButton.setCursor(this.arrowCursor);
            }
            map = this.saveUIState(this.useCustomProgressMonitorPart && bl2 && bl);
            if (control != null) {
                map.put(FOCUS_CONTROL, control);
            }
            if (bl2) {
                if (bl || this.useCustomProgressMonitorPart) {
                    this.progressMonitorPart.attachToCancelComponent((Control)this.cancelButton);
                }
                this.progressMonitorPart.setVisible(true);
            }
            if (this.timeWhenLastJobFinished == -1L) {
                this.timeWhenLastJobFinished = 0L;
                this.getShell().addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent traverseEvent) {
                        if (traverseEvent.detail == 4 || traverseEvent.detail == 128 && traverseEvent.keyCode == 32) {
                            if (ModelioWizardDialog.this.timeWhenLastJobFinished != 0L && System.currentTimeMillis() - ModelioWizardDialog.this.timeWhenLastJobFinished < 500L) {
                                traverseEvent.doit = false;
                                return;
                            }
                            ModelioWizardDialog.this.timeWhenLastJobFinished = 0L;
                        }
                    }
                });
            }
        }
        return map;
    }

    protected void backPressed() {
        IWizardPage iWizardPage = this.currentPage.getPreviousPage();
        if (iWizardPage == null) {
            return;
        }
        this.isMovingToPreviousPage = true;
        this.showPage(iWizardPage);
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 17: {
                this.helpPressed();
                break;
            }
            case 14: {
                this.backPressed();
                break;
            }
            case 15: {
                this.nextPressed();
                break;
            }
            case 16: {
                this.finishPressed();
                break;
            }
        }
    }

    private Point calculatePageSizeDelta(IWizardPage iWizardPage) {
        Control control = iWizardPage.getControl();
        if (control == null) {
            return new Point(0, 0);
        }
        Point point = control.computeSize(-1, -1, true);
        Rectangle rectangle = this.pageContainerLayout.getClientArea(this.pageContainer);
        Point point2 = new Point(rectangle.width, rectangle.height);
        return new Point(Math.max(0, point.x - point2.x), Math.max(0, point.y - point2.y));
    }

    protected void cancelPressed() {
        if (this.activeRunningOperations <= 0L) {
            this.setReturnCode(1);
            this.close();
        } else {
            this.cancelButton.setEnabled(false);
        }
    }

    public boolean close() {
        if (this.okToClose()) {
            return this.hardClose();
        }
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                if (ModelioWizardDialog.this.currentPage != null) {
                    ModelioWizardDialog.this.currentPage.performHelp();
                }
            }
        });
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        if (this.wizard.isHelpAvailable()) {
            this.helpButton = this.createButton(composite, 17, IDialogConstants.HELP_LABEL, false);
        }
        if (this.wizard.needsPreviousAndNextButtons()) {
            this.createPreviousAndNextButtons(composite);
        }
        this.finishButton = this.createButton(composite, 16, IDialogConstants.FINISH_LABEL, true);
        this.cancelButton = this.createCancelButton(composite);
        if (composite.getDisplay().getDismissalAlignment() == 131072) {
            this.finishButton.moveBelow(null);
        }
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        n = Math.min(n, button.getDisplay().getBounds().width / 5);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(n, point.x);
        button.setLayoutData((Object)gridData);
    }

    private Button createCancelButton(Composite composite) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setText(IDialogConstants.CANCEL_LABEL);
        this.setButtonLayoutData(button);
        button.setFont(composite.getFont());
        button.setData((Object)1);
        button.addSelectionListener((SelectionListener)this.cancelListener);
        return button;
    }

    protected Button getButton(int n) {
        if (n == 1) {
            return this.cancelButton;
        }
        return super.getButton(n);
    }

    @Override
    protected Control createContents(Composite composite) {
        this.wizard.addPages();
        Control control = super.createContents(composite);
        this.createPageControls();
        this.showStartingPage();
        return control;
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.pageContainer = this.createPageContainer(composite2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.pageWidth;
        gridData.heightHint = this.pageHeight;
        this.pageContainer.setLayoutData((Object)gridData);
        this.pageContainer.setFont(composite.getFont());
        this.progressMonitorPart = this.createProgressMonitorPart(composite2, new GridLayout());
        GridData gridData2 = new GridData(768);
        this.progressMonitorPart.setLayoutData((Object)gridData2);
        this.progressMonitorPart.setVisible(false);
        Label label = new Label(composite2, 258);
        label.setLayoutData((Object)new GridData(768));
        ModelioWizardDialog.applyDialogFont((Control)this.progressMonitorPart);
        return composite2;
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout gridLayout) {
        this.useCustomProgressMonitorPart = false;
        return new ProgressMonitorPart(composite, (Layout)gridLayout, true);
    }

    private Composite createPageContainer(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.pageContainerLayout);
        return composite2;
    }

    private void createPageControls() {
        this.wizard.createPageControls(this.pageContainer);
        IWizardPage[] iWizardPageArray = this.wizard.getPages();
        for (int i = 0; i < iWizardPageArray.length; ++i) {
            IWizardPage iWizardPage = iWizardPageArray[i];
            if (iWizardPage.getControl() == null) continue;
            iWizardPage.getControl().setVisible(false);
        }
    }

    private Composite createPreviousAndNextButtons(Composite composite) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(68);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        this.backButton = this.createButton(composite2, 14, IDialogConstants.BACK_LABEL, false);
        this.nextButton = this.createButton(composite2, 15, IDialogConstants.NEXT_LABEL, false);
        return composite2;
    }

    private MessageDialog createWizardClosingDialog() {
        MessageDialog messageDialog = new MessageDialog(this.getShell(), JFaceResources.getString((String)"WizardClosingDialog.title"), null, JFaceResources.getString((String)"WizardClosingDialog.message"), 3, new String[]{IDialogConstants.OK_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        return messageDialog;
    }

    protected void finishPressed() {
        if (this.wizard.performFinish()) {
            for (int i = 0; i < this.nestedWizards.size() - 1; ++i) {
                this.nestedWizards.get(i).performFinish();
            }
            this.setReturnCode(0);
            this.hardClose();
        }
    }

    public IWizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitorPart;
    }

    protected IWizard getWizard() {
        return this.wizard;
    }

    private boolean hardClose() {
        for (int i = 0; i < this.createdWizards.size(); ++i) {
            IWizard iWizard = this.createdWizards.get(i);
            iWizard.dispose();
            iWizard.setContainer(null);
        }
        this.setTitleLeftImage(null);
        return super.close();
    }

    protected void helpPressed() {
        if (this.currentPage != null) {
            this.currentPage.performHelp();
        }
    }

    protected void nextPressed() {
        IWizardPage iWizardPage = this.currentPage.getNextPage();
        if (iWizardPage == null) {
            return;
        }
        this.showPage(iWizardPage);
    }

    private boolean doPageChanging(IWizardPage iWizardPage) {
        PageChangingEvent pageChangingEvent = new PageChangingEvent((Object)this, (Object)this.getCurrentPage(), (Object)iWizardPage);
        this.firePageChanging(pageChangingEvent);
        return pageChangingEvent.doit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okToClose() {
        if (this.activeRunningOperations > 0L) {
            ModelioWizardDialog modelioWizardDialog = this;
            synchronized (modelioWizardDialog) {
                this.windowClosingDialog = this.createWizardClosingDialog();
                this.windowClosingDialog.open();
                this.windowClosingDialog = null;
            }
            return false;
        }
        return this.wizard.performCancel();
    }

    private void restoreEnableState(Control control, Map map, String string) {
        Boolean bl;
        if (control != null && (bl = (Boolean)map.get(string)) != null) {
            control.setEnabled(bl.booleanValue());
        }
    }

    private void restoreUIState(Map map) {
        this.restoreEnableState((Control)this.backButton, map, "back");
        this.restoreEnableState((Control)this.nextButton, map, "next");
        this.restoreEnableState((Control)this.finishButton, map, "finish");
        this.restoreEnableState((Control)this.cancelButton, map, "cancel");
        this.restoreEnableState((Control)this.helpButton, map, "help");
        Object v = map.get("page");
        if (v != null) {
            ((ControlEnableState)v).restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        Object object = null;
        if (this.activeRunningOperations == 0L) {
            object = this.aboutToStart(bl && bl2);
        }
        ++this.activeRunningOperations;
        try {
            if (!bl) {
                this.lockedUI = true;
            }
            ModalContext.run((IRunnableWithProgress)iRunnableWithProgress, (boolean)bl, (IProgressMonitor)this.getProgressMonitor(), (Display)this.getShell().getDisplay());
            this.lockedUI = false;
        }
        finally {
            if (this.getProgressMonitor() != null) {
                this.getProgressMonitor().done();
            }
            if (object != null) {
                this.timeWhenLastJobFinished = System.currentTimeMillis();
                this.stopped(object);
            }
            --this.activeRunningOperations;
        }
    }

    private void saveEnableStateAndSet(Control control, Map<String, Boolean> map, String string, boolean bl) {
        if (control != null) {
            map.put(string, control.getEnabled() ? Boolean.TRUE : Boolean.FALSE);
            control.setEnabled(bl);
        }
    }

    private Map saveUIState(boolean bl) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(10);
        this.saveEnableStateAndSet((Control)this.backButton, hashMap, "back", false);
        this.saveEnableStateAndSet((Control)this.nextButton, hashMap, "next", false);
        this.saveEnableStateAndSet((Control)this.finishButton, hashMap, "finish", false);
        this.saveEnableStateAndSet((Control)this.cancelButton, hashMap, "cancel", bl);
        this.saveEnableStateAndSet((Control)this.helpButton, hashMap, "help", false);
        if (this.currentPage != null) {
            hashMap.put("page", (Boolean)ControlEnableState.disable((Control)this.currentPage.getControl()));
        }
        return hashMap;
    }

    private void setDisplayCursor(Cursor cursor) {
        Shell[] shellArray = this.getShell().getDisplay().getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].setCursor(cursor);
        }
    }

    public void setMinimumPageSize(int n, int n2) {
        Assert.isTrue((n >= 0 && n2 >= 0 ? 1 : 0) != 0);
        this.pageContainerLayout.minimumWidth = n;
        this.pageContainerLayout.minimumHeight = n2;
    }

    public void setMinimumPageSize(Point point) {
        this.setMinimumPageSize(point.x, point.y);
    }

    public void setPageSize(int n, int n2) {
        this.pageWidth = n;
        this.pageHeight = n2;
    }

    public void setPageSize(Point point) {
        this.setPageSize(point.x, point.y);
    }

    protected void setWizard(IWizard iWizard) {
        this.wizard = iWizard;
        this.wizard.setContainer((IWizardContainer)this);
        if (!this.createdWizards.contains(this.wizard)) {
            this.createdWizards.add(this.wizard);
            this.nestedWizards.add(this.wizard);
            if (this.pageContainer != null) {
                this.createPageControls();
                this.updateSizeForWizard(this.wizard);
                this.pageContainer.layout(true);
            }
        } else {
            int n = this.nestedWizards.size();
            if (n >= 2 && this.nestedWizards.get(n - 2) == this.wizard) {
                this.nestedWizards.remove(n - 1);
            } else {
                this.nestedWizards.add(this.wizard);
            }
        }
    }

    public void showPage(IWizardPage iWizardPage) {
        if (iWizardPage == null || iWizardPage == this.currentPage) {
            return;
        }
        if (!this.isMovingToPreviousPage) {
            iWizardPage.setPreviousPage(this.currentPage);
        } else {
            this.isMovingToPreviousPage = false;
        }
        if (!this.doPageChanging(iWizardPage)) {
            return;
        }
        if (this.getContents() == null) {
            this.updateForPage(iWizardPage);
        } else {
            final IWizardPage iWizardPage2 = iWizardPage;
            BusyIndicator.showWhile((Display)this.getContents().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ModelioWizardDialog.this.updateForPage(iWizardPage2);
                }
            });
        }
    }

    private void updateForPage(IWizardPage iWizardPage) {
        if (this.wizard != iWizardPage.getWizard()) {
            this.setWizard(iWizardPage.getWizard());
        }
        if (iWizardPage.getControl() == null) {
            iWizardPage.createControl(this.pageContainer);
            Assert.isNotNull((Object)iWizardPage.getControl(), (String)JFaceResources.format((String)JFaceResources.getString((String)"WizardDialog.missingSetControl"), (Object[])new Object[]{iWizardPage.getName()}));
            this.updateSize(iWizardPage);
        }
        IWizardPage iWizardPage2 = this.currentPage;
        this.currentPage = iWizardPage;
        this.currentPage.setVisible(true);
        if (iWizardPage2 != null) {
            iWizardPage2.setVisible(false);
        }
        this.update();
    }

    private void showStartingPage() {
        this.currentPage = this.wizard.getStartingPage();
        if (this.currentPage == null) {
            return;
        }
        if (this.currentPage.getControl() == null) {
            this.currentPage.createControl(this.pageContainer);
            Assert.isNotNull((Object)this.currentPage.getControl());
        }
        this.currentPage.setVisible(true);
        this.update();
    }

    private void stopped(Object object) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            if (this.wizard.needsProgressMonitor()) {
                this.progressMonitorPart.setVisible(false);
                this.progressMonitorPart.removeFromCancelComponent((Control)this.cancelButton);
            }
            Map map = (Map)object;
            this.restoreUIState(map);
            this.setDisplayCursor(null);
            if (this.useCustomProgressMonitorPart) {
                this.cancelButton.addSelectionListener((SelectionListener)this.cancelListener);
                this.cancelButton.setCursor(null);
                this.arrowCursor.dispose();
                this.arrowCursor = null;
            }
            this.waitCursor.dispose();
            this.waitCursor = null;
            Control control = (Control)map.get(FOCUS_CONTROL);
            if (control != null && !control.isDisposed()) {
                control.setFocus();
            }
        }
    }

    protected void update() {
        this.updateWindowTitle();
        this.updateTitleBar();
        this.updateButtons();
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)this.getCurrentPage()));
    }

    public void updateButtons() {
        boolean bl = false;
        boolean bl2 = this.wizard.canFinish();
        if (this.backButton != null) {
            this.backButton.setEnabled(this.currentPage.getPreviousPage() != null);
        }
        if (this.nextButton != null) {
            bl = this.currentPage.canFlipToNextPage();
            this.nextButton.setEnabled(bl);
        }
        this.finishButton.setEnabled(bl2);
        if (bl && !bl2) {
            this.getShell().setDefaultButton(this.nextButton);
        } else {
            this.getShell().setDefaultButton(this.finishButton);
        }
    }

    private void updateDescriptionMessage() {
        this.pageDescription = this.currentPage.getDescription();
        this.setMessage(this.pageDescription);
    }

    public void updateMessage() {
        if (this.currentPage == null) {
            return;
        }
        String string = this.currentPage.getMessage();
        this.pageMessageType = string != null && this.currentPage instanceof IMessageProvider ? ((IMessageProvider)this.currentPage).getMessageType() : 0;
        if (string == null) {
            this.setMessage(this.pageDescription);
        } else {
            this.setMessage(string, this.pageMessageType);
        }
        this.setErrorMessage(this.currentPage.getErrorMessage());
    }

    private void setShellSize(int n, int n2) {
        Rectangle rectangle = this.getShell().getBounds();
        rectangle.height = n2;
        rectangle.width = n;
        this.getShell().setBounds(this.getConstrainedShellBounds(rectangle));
    }

    protected void updateSize(IWizardPage iWizardPage) {
        if (iWizardPage == null || iWizardPage.getControl() == null) {
            return;
        }
        this.updateSizeForPage(iWizardPage);
        this.pageContainerLayout.layoutPage(iWizardPage.getControl());
    }

    public void updateSize() {
        this.updateSize(this.currentPage);
    }

    private void updateSizeForPage(IWizardPage iWizardPage) {
        Point point = this.calculatePageSizeDelta(iWizardPage);
        if (point.x > 0 || point.y > 0) {
            Shell shell = this.getShell();
            Point point2 = shell.getSize();
            this.setShellSize(point2.x + point.x, point2.y + point.y);
            this.constrainShellSize();
        }
    }

    private void updateSizeForWizard(IWizard iWizard) {
        Point point;
        Point point2 = new Point(0, 0);
        IWizardPage[] iWizardPageArray = iWizard.getPages();
        for (int i = 0; i < iWizardPageArray.length; ++i) {
            point = this.calculatePageSizeDelta(iWizardPageArray[i]);
            point2.x = Math.max(point2.x, point.x);
            point2.y = Math.max(point2.y, point.y);
        }
        if (point2.x > 0 || point2.y > 0) {
            Shell shell = this.getShell();
            point = shell.getSize();
            this.setShellSize(point.x + point2.x, point.y + point2.y);
        }
    }

    public void updateTitleBar() {
        String string = null;
        if (this.currentPage != null) {
            string = this.currentPage.getTitle();
        }
        if (string == null) {
            string = "";
        }
        this.setTitle(string);
        if (this.currentPage != null) {
            this.updateDescriptionMessage();
        }
        this.updateMessage();
    }

    public void updateWindowTitle() {
        if (this.getShell() == null) {
            return;
        }
        String string = this.wizard.getWindowTitle();
        if (string == null) {
            string = "";
        }
        this.getShell().setText(string);
    }

    public Object getSelectedPage() {
        return this.getCurrentPage();
    }

    public void addPageChangedListener(IPageChangedListener iPageChangedListener) {
        this.pageChangedListeners.add((Object)iPageChangedListener);
    }

    public void removePageChangedListener(IPageChangedListener iPageChangedListener) {
        this.pageChangedListeners.remove((Object)iPageChangedListener);
    }

    protected void firePageChanged(final PageChangedEvent pageChangedEvent) {
        Object[] objectArray = this.pageChangedListeners.getListeners();
        for (int i = 0; i < objectArray.length; ++i) {
            final IPageChangedListener iPageChangedListener = (IPageChangedListener)objectArray[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iPageChangedListener.pageChanged(pageChangedEvent);
                }
            });
        }
    }

    public void addPageChangingListener(IPageChangingListener iPageChangingListener) {
        this.pageChangingListeners.add((Object)iPageChangingListener);
    }

    public void removePageChangingListener(IPageChangingListener iPageChangingListener) {
        this.pageChangingListeners.remove((Object)iPageChangingListener);
    }

    protected void firePageChanging(final PageChangingEvent pageChangingEvent) {
        Object[] objectArray = this.pageChangingListeners.getListeners();
        for (int i = 0; i < objectArray.length; ++i) {
            final IPageChangingListener iPageChangingListener = (IPageChangingListener)objectArray[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iPageChangingListener.handlePageChanging(pageChangingEvent);
                }
            });
        }
    }

    @Override
    public void addButtonsInButtonBar(Composite composite) {
        super.addDefaultButtons(composite);
    }

    @Override
    public Control createContentArea(Composite composite) {
        return composite;
    }

    @Override
    public void init() {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.ui", (String)"icons/headerLeft.png");
        Image image = imageDescriptor.createImage();
        this.setTitleLeftImage(image);
    }

    class MWDProgressMonitorPart
    extends ProgressMonitorPart {
        private String currentTask;

        public MWDProgressMonitorPart(Composite composite, Layout layout, boolean bl) {
            super(composite, layout, bl);
            this.currentTask = null;
        }

        public void setBlocked(IStatus iStatus) {
            super.setBlocked(iStatus);
            if (!ModelioWizardDialog.this.lockedUI) {
                Dialog.getBlockedHandler().showBlocked(this.getShell(), (IProgressMonitor)this, iStatus, this.currentTask);
            }
        }

        public void clearBlocked() {
            super.clearBlocked();
            if (!ModelioWizardDialog.this.lockedUI) {
                Dialog.getBlockedHandler().clearBlocked();
            }
        }

        public void beginTask(String string, int n) {
            super.beginTask(string, n);
            this.currentTask = string;
        }

        public void setTaskName(String string) {
            super.setTaskName(string);
            this.currentTask = string;
        }

        public void subTask(String string) {
            super.subTask(string);
            if (this.currentTask == null) {
                this.currentTask = string;
            }
        }
    }

    protected static class PageContainerFillLayout
    extends Layout {
        public int marginWidth = 5;
        public int marginHeight = 5;
        public int minimumWidth = 0;
        public int minimumHeight = 0;

        public PageContainerFillLayout(int n, int n2, int n3, int n4) {
            this.marginWidth = n;
            this.marginHeight = n2;
            this.minimumWidth = n3;
            this.minimumHeight = n4;
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Point point = null;
            Control[] controlArray = composite.getChildren();
            if (controlArray.length > 0) {
                point = new Point(0, 0);
                for (int i = 0; i < controlArray.length; ++i) {
                    Point point2 = controlArray[i].computeSize(n, n2, bl);
                    point.x = Math.max(point.x, point2.x);
                    point.y = Math.max(point.y, point2.y);
                }
                point.x += 2 * this.marginWidth;
                point.y += 2 * this.marginHeight;
            } else {
                Rectangle rectangle = composite.getClientArea();
                point = new Point(rectangle.width, rectangle.height);
            }
            point.x = Math.max(point.x, this.minimumWidth);
            point.y = Math.max(point.y, this.minimumHeight);
            if (n != -1) {
                point.x = n;
            }
            if (n2 != -1) {
                point.y = n2;
            }
            return point;
        }

        public Rectangle getClientArea(Composite composite) {
            Rectangle rectangle = composite.getClientArea();
            rectangle.x += this.marginWidth;
            rectangle.y += this.marginHeight;
            rectangle.width -= 2 * this.marginWidth;
            rectangle.height -= 2 * this.marginHeight;
            return rectangle;
        }

        public void layout(Composite composite, boolean bl) {
            Rectangle rectangle = this.getClientArea(composite);
            Control[] controlArray = composite.getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].setBounds(rectangle);
            }
        }

        public void layoutPage(Control control) {
            control.setBounds(this.getClientArea(control.getParent()));
        }

        public void setPageLocation(Control control) {
            control.setLocation(this.marginWidth, this.marginHeight);
        }
    }
}

