/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui.diagramcreation;

import com.modeliosoft.modelio.api.Messages;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.api.ui.diagramcreation.BrowserDialog;
import com.modeliosoft.modelio.api.ui.diagramcreation.ContributionModel;
import com.modeliosoft.modelio.api.ui.diagramcreation.DiagramWizardModel;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.ui.text.TextWrapperForIElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class DiagramWizardDialog
extends ModelioDialog
implements Listener {
    protected Button okButton;
    protected Button cancelButton;
    protected Button hideInvalidCheckBox;
    protected TextWrapperForIElement contextText;
    protected Text nameText;
    protected StyledText descriptionText;
    protected Table diagramList;
    protected DiagramWizardModel dataModel;
    protected ContributionModel contributionModel;
    protected DiagramWizardModel resultModel = null;
    protected StyledText detailsText;

    public DiagramWizardDialog(Shell shell, ContributionModel contributionModel, DiagramWizardModel diagramWizardModel) {
        super(shell);
        this.setShellStyle(3184);
        this.contributionModel = contributionModel;
        this.dataModel = diagramWizardModel;
    }

    public void setShowInvalidDiagram(Boolean bl) {
        this.dataModel.setShowInvalidDiagram(bl);
    }

    public void seDefaultContributor(IDiagramWizardContributor iDiagramWizardContributor) {
        this.dataModel.setSelectedContributor(iDiagramWizardContributor);
    }

    public List<IDiagramWizardContributor> getValidContributors(IElement iElement) {
        ArrayList<IDiagramWizardContributor> arrayList = new ArrayList<IDiagramWizardContributor>();
        for (IDiagramWizardContributor iDiagramWizardContributor : this.contributionModel.getDiagramContributors()) {
            if (iElement == null || !iDiagramWizardContributor.accept(iElement)) continue;
            arrayList.add(iDiagramWizardContributor);
        }
        return arrayList;
    }

    public List<IDiagramWizardContributor> getInvalidContributors(IElement iElement) {
        ArrayList<IDiagramWizardContributor> arrayList = new ArrayList<IDiagramWizardContributor>();
        for (IDiagramWizardContributor iDiagramWizardContributor : this.contributionModel.getDiagramContributors()) {
            if (iElement == null || iDiagramWizardContributor.accept(iElement)) continue;
            arrayList.add(iDiagramWizardContributor);
        }
        return arrayList;
    }

    private void update() {
        TableItem tableItem;
        IDiagramWizardContributor iDiagramWizardContributor = this.dataModel.getSelectedContributor();
        if (iDiagramWizardContributor != null) {
            this.contextText.removeAllowedMetaclasses(this.contextText.getAllowedMetaclasses());
            this.contextText.addAllowedMetaclasses(iDiagramWizardContributor.getAllowedMetaclasses());
            this.contextText.setAcceptNullValue(false);
            this.contextText.getTextField().setForeground(ColorConstants.red);
        }
        this.diagramList.removeAll();
        for (IDiagramWizardContributor iDiagramWizardContributor2 : this.getValidContributors((IElement)this.dataModel.getContext())) {
            tableItem = new TableItem(this.diagramList, 0);
            tableItem.setImage(iDiagramWizardContributor2.getImage());
            tableItem.setText(iDiagramWizardContributor2.getCommandName());
            tableItem.setData((Object)iDiagramWizardContributor2);
            if (iDiagramWizardContributor == null || !iDiagramWizardContributor2.equals(iDiagramWizardContributor)) continue;
            this.contextText.getTextField().setForeground(UIColor.BLACK);
            this.diagramList.setSelection(tableItem);
            this.nameText.setText(iDiagramWizardContributor.getCommandName());
            this.updateDetailsText(iDiagramWizardContributor.getDetails());
            this.setMessage(iDiagramWizardContributor.getInformation());
        }
        if (this.dataModel.isShowInvalidDiagram()) {
            for (IDiagramWizardContributor iDiagramWizardContributor2 : this.getInvalidContributors((IElement)this.dataModel.getContext())) {
                tableItem = new TableItem(this.diagramList, 0);
                tableItem.setImage(iDiagramWizardContributor2.getImage());
                tableItem.setText(iDiagramWizardContributor2.getCommandName());
                tableItem.setGrayed(true);
                tableItem.setForeground(0, ColorConstants.gray);
                tableItem.setData((Object)iDiagramWizardContributor2);
                if (iDiagramWizardContributor == null || !iDiagramWizardContributor2.equals(iDiagramWizardContributor)) continue;
                this.diagramList.setSelection(tableItem);
                this.nameText.setText(iDiagramWizardContributor.getCommandName());
                this.updateDetailsText(iDiagramWizardContributor.getDetails());
                this.setMessage(iDiagramWizardContributor.getInformation());
            }
        }
        for (TableColumn tableColumn : this.diagramList.getColumns()) {
            tableColumn.pack();
        }
    }

    public void handleEvent(Event event) {
        if (event.widget.equals(this.nameText)) {
            this.dataModel.setName(this.nameText.getText());
        } else if (event.widget.equals(this.descriptionText)) {
            this.dataModel.setDescription(this.descriptionText.getText());
        } else if (event.widget.equals(this.hideInvalidCheckBox)) {
            this.dataModel.setShowInvalidDiagram(!this.hideInvalidCheckBox.getSelection());
            this.update();
        } else if (event.widget.equals(this.diagramList)) {
            this.dataModel.setSelectedContributor((IDiagramWizardContributor)this.diagramList.getSelection()[0].getData());
            this.update();
        } else if (event.widget.equals(this.contextText.getTextField())) {
            this.dataModel.setContext((IModelElement)this.contextText.getTextField().getData());
            this.update();
        } else if (event.widget.equals(this.detailsText)) {
            try {
                int n = this.detailsText.getOffsetAtLocation(new Point(event.x, event.y));
                StyleRange styleRange = this.detailsText.getStyleRangeAtOffset(n);
                if (styleRange != null && styleRange.underline && styleRange.underlineStyle == 4) {
                    this.openBrowser();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.dataModel.getSelectedContributor() != null && this.dataModel.getSelectedContributor().accept((IElement)this.dataModel.getContext())) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    @Override
    public void addButtonsInButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.cancelButton = this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void addListeners() {
        this.nameText.addListener(24, (Listener)this);
        this.descriptionText.addListener(24, (Listener)this);
        this.hideInvalidCheckBox.addListener(13, (Listener)this);
        this.diagramList.addListener(13, (Listener)this);
        this.diagramList.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (DiagramWizardDialog.this.diagramList.getItem(new Point(mouseEvent.x, mouseEvent.y)) != null && DiagramWizardDialog.this.okButton.isEnabled()) {
                    DiagramWizardDialog.this.okPressed();
                }
            }
        });
        this.cancelButton.addListener(1, (Listener)this);
        this.okButton.addListener(0, (Listener)this);
        this.contextText.getTextField().addListener(24, (Listener)this);
        this.detailsText.addListener(3, (Listener)this);
    }

    protected void okPressed() {
        super.okPressed();
        this.resultModel = this.dataModel;
    }

    @Override
    public Control createContentArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FormLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.bottom = new FormAttachment(100, -10);
        formData.left = new FormAttachment(0, 10);
        composite3.setLayoutData((Object)formData);
        this.diagramList = new Table(composite3, 2048);
        this.diagramList.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        TableColumn tableColumn = new TableColumn(this.diagramList, 0x1000000);
        tableColumn.setResizable(false);
        tableColumn.setWidth(200);
        this.hideInvalidCheckBox = new Button(composite3, 32);
        this.hideInvalidCheckBox.setText(Messages.getMessage("Ui.DiagramCreationWizard.HideInvalid", new String[0]));
        this.hideInvalidCheckBox.setLayoutData((Object)new GridData(4, 4, true, false));
        ToolBar toolBar = new ToolBar(composite3, 0x880000);
        toolBar.setLayoutData((Object)new GridData(131072, 1024, false, false));
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(65, 0);
        formData2.bottom = new FormAttachment(100, -10);
        formData2.left = new FormAttachment((Control)composite3, 10);
        formData2.right = new FormAttachment(100, -10);
        composite4.setLayoutData((Object)formData2);
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment(0, 10);
        formData3.left = new FormAttachment((Control)composite3, 10);
        formData3.right = new FormAttachment(100, -10);
        formData3.bottom = new FormAttachment((Control)composite4, -10);
        group.setLayoutData((Object)formData3);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.getMessage("Ui.DiagramCreationWizard.Name", new String[0]));
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.nameText = new Text((Composite)group, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label2 = new Label((Composite)group, 0);
        label2.setText(Messages.getMessage("Ui.DiagramCreationWizard.Context", new String[0]));
        label2.setLayoutData((Object)new GridData(4, 4, false, false));
        this.contextText = new TextWrapperForIElement((Composite)group, null, false, null);
        this.contextText.getTextField().setLayoutData((Object)new GridData(4, 4, true, false));
        Label label3 = new Label((Composite)group, 0);
        label3.setText(Messages.getMessage("Ui.DiagramCreationWizard.Description", new String[0]));
        label3.setLayoutData((Object)new GridData(4, 4, false, false));
        this.descriptionText = new StyledText((Composite)group, 2112);
        this.descriptionText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.descriptionText.setBackground(UIColor.TEXT_READONLY_BG);
        this.descriptionText.setForeground(UIColor.EDITOR_ROTEXT_FG);
        this.descriptionText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                DiagramWizardDialog.this.descriptionText.setBackground(UIColor.TEXT_READONLY_BG);
            }

            public void focusGained(FocusEvent focusEvent) {
                DiagramWizardDialog.this.descriptionText.setBackground(UIColor.TEXT_WRITABLE_BG);
            }
        });
        this.detailsText = new StyledText(composite4, 66);
        this.detailsText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.detailsText.setForeground(UIColor.LABEL_TIP_FG);
        this.detailsText.setEditable(false);
        this.detailsText.setBackground(composite4.getBackground());
        this.update();
        return composite2;
    }

    protected void openBrowser() {
        String string = this.dataModel.getSelectedContributor().getHelpUrl();
        if (string != null) {
            BrowserDialog browserDialog = new BrowserDialog(this.getShell(), string);
            browserDialog.open();
        }
    }

    @Override
    public void init() {
        Shell shell = this.getShell();
        shell.setSize(650, 500);
        int n = this.getShell().getSize().x / 2 - 250;
        int n2 = this.getShell().getSize().y / 2 - 100;
        shell.setLocation(n, n2);
        shell.setMinimumSize(800, 600);
        shell.setText(Messages.getMessage("Ui.DiagramCreationWizard.ShellTitle", new String[0]));
        this.setTitle(Messages.getMessage("Ui.DiagramCreationWizard.Title", new String[0]));
        this.setMessage(Messages.getMessage("Ui.DiagramCreationWizard.Message", new String[0]));
        this.nameText.setText(this.dataModel.getName());
        this.descriptionText.setText(this.dataModel.getDescription());
        this.hideInvalidCheckBox.setSelection(!this.dataModel.isShowInvalidDiagram());
        this.addListeners();
        if (this.dataModel.getSelectedContributor() == null) {
            IModelElement iModelElement;
            IModelElement iModelElement2;
            List<IDiagramWizardContributor> list = this.getValidContributors((IElement)iModelElement2);
            for (iModelElement2 = iModelElement = this.dataModel.getContext(); list.size() == 0 && iModelElement2 != null; iModelElement2 = iModelElement2.getCompositionOwner()) {
                list = this.getValidContributors((IElement)iModelElement2);
            }
            if (list.size() > 0) {
                IDiagramWizardContributor iDiagramWizardContributor = list.get(0);
                this.dataModel.setSelectedContributor(iDiagramWizardContributor);
                this.contextText.addAllowedMetaclasses(iDiagramWizardContributor.getAllowedMetaclasses());
                this.contextText.setAcceptNullValue(false);
                this.contextText.setElement((IElement)iModelElement2);
                this.dataModel.setContext(iModelElement2);
            }
        } else {
            IModelElement iModelElement;
            IModelElement iModelElement3;
            IDiagramWizardContributor iDiagramWizardContributor = this.dataModel.getSelectedContributor();
            for (iModelElement3 = iModelElement = this.dataModel.getContext(); !iDiagramWizardContributor.accept((IElement)iModelElement3) && iModelElement3 != null; iModelElement3 = iModelElement3.getCompositionOwner()) {
            }
            this.contextText.addAllowedMetaclasses(iDiagramWizardContributor.getAllowedMetaclasses());
            this.contextText.setAcceptNullValue(false);
            this.contextText.setElement((IElement)iModelElement3);
            this.dataModel.setContext(iModelElement3);
        }
        this.update();
    }

    public DiagramWizardModel getResultModel() {
        return this.resultModel;
    }

    public boolean close() {
        this.contextText.pickingAborted();
        return super.close();
    }

    private void updateDetailsText(String string) {
        String string2 = this.dataModel.getSelectedContributor().getHelpUrl();
        if (string2 != null) {
            String string3 = Messages.getMessage("Ui.DiagramCreationWizard.More", new String[0]);
            this.detailsText.setText(string + string3);
            StyleRange styleRange = new StyleRange();
            styleRange.underline = true;
            styleRange.underlineStyle = 4;
            int[] nArray = new int[]{this.detailsText.getText().length() - string3.length() + 1, string3.length() - 1};
            StyleRange[] styleRangeArray = new StyleRange[]{styleRange};
            this.detailsText.setStyleRanges(nArray, styleRangeArray);
        } else {
            this.detailsText.setText(string);
        }
    }
}

