/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui.dnd;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.dnd.IEditorDropClient;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.api.utils.ObRef;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;

public class EditorDropListener
implements DropTargetListener {
    private IEditorDropClient client;

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        int n;
        ModelElementTransfer modelElementTransfer = ModelElementTransfer.getInstance();
        for (n = 0; n < dropTargetEvent.dataTypes.length; ++n) {
            if (!modelElementTransfer.isSupportedType(dropTargetEvent.dataTypes[n])) continue;
            dropTargetEvent.currentDataType = dropTargetEvent.dataTypes[n];
            break;
        }
        if (modelElementTransfer.isSupportedType(dropTargetEvent.currentDataType)) {
            n = 0;
            ObRef[] obRefArray = (ObRef[])modelElementTransfer.nativeToJava(dropTargetEvent.currentDataType);
            if (obRefArray != null) {
                IElement[] iElementArray = new IElement[obRefArray.length];
                for (int i = 0; i < iElementArray.length; ++i) {
                    iElementArray[i] = Modelio.getInstance().getModelingSession().findByRef(obRefArray[i]);
                }
                if (iElementArray.length > 0) {
                    n = this.client.acceptDroppedElements(iElementArray) ? 1 : 0;
                }
            } else {
                n = 1;
            }
            if (n == 0) {
                dropTargetEvent.detail = 0;
            }
        }
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        ObRef[] obRefArray;
        if (ModelElementTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType) && (obRefArray = (ObRef[])dropTargetEvent.data) != null) {
            IElement[] iElementArray = new IElement[obRefArray.length];
            for (int i = 0; i < iElementArray.length; ++i) {
                iElementArray[i] = Modelio.getInstance().getModelingSession().findByRef(obRefArray[i]);
            }
            if (this.client.acceptDroppedElements(iElementArray)) {
                this.client.setDroppedElements(iElementArray);
            }
        }
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
    }

    public EditorDropListener(IEditorDropClient iEditorDropClient) {
        this.client = iEditorDropClient;
    }
}

