/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui.dnd;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class LinuxDropTarget
extends DropTarget
implements DropTargetListener {
    private Map<Control, DropTargetListener> delegationMap = new HashMap<Control, DropTargetListener>();
    private Set<Control> alreadyInControls = new HashSet<Control>();

    public LinuxDropTarget(Control control, int n) {
        super(control, n);
        super.addDropListener((DropTargetListener)this);
    }

    public void addDropListener(Control control, DropTargetListener dropTargetListener) {
        this.delegationMap.put(control, dropTargetListener);
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        for (Control control : this.delegationMap.keySet()) {
            if (!this.isDelegated(control, dropTargetEvent)) continue;
            this.delegationMap.get(control).dragEnter(dropTargetEvent);
            this.alreadyInControls.add(control);
        }
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        for (Control control : this.delegationMap.keySet()) {
            if (!this.isDelegated(control, dropTargetEvent)) continue;
            this.delegationMap.get(control).dragLeave(dropTargetEvent);
            this.alreadyInControls.remove(control);
        }
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        for (Control control : this.delegationMap.keySet()) {
            if (!this.isDelegated(control, dropTargetEvent)) continue;
            this.delegationMap.get(control).dragOperationChanged(dropTargetEvent);
        }
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        for (Control control : this.delegationMap.keySet()) {
            if (this.isDelegated(control, dropTargetEvent)) {
                if (!this.isAlreadyIn(control)) {
                    this.delegationMap.get(control).dragEnter(dropTargetEvent);
                    this.alreadyInControls.add(control);
                    continue;
                }
                this.delegationMap.get(control).dragOver(dropTargetEvent);
                continue;
            }
            if (!this.isAlreadyIn(control)) continue;
            this.delegationMap.get(control).dragLeave(dropTargetEvent);
            this.alreadyInControls.remove(control);
        }
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        for (Control control : this.delegationMap.keySet()) {
            if (!this.isDelegated(control, dropTargetEvent)) continue;
            this.delegationMap.get(control).drop(dropTargetEvent);
        }
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        for (Control control : this.delegationMap.keySet()) {
            if (!this.isDelegated(control, dropTargetEvent)) continue;
            this.delegationMap.get(control).dropAccept(dropTargetEvent);
        }
    }

    protected void checkSubclass() {
    }

    private boolean isDelegated(Control control, DropTargetEvent dropTargetEvent) {
        Point point = Display.getDefault().map(null, control, dropTargetEvent.x, dropTargetEvent.y);
        Rectangle rectangle = control.getBounds();
        boolean bl = point.x >= 0 && point.y >= 0 && point.x < rectangle.width && point.y < rectangle.height;
        return bl && control.isVisible() && this.getControl().isVisible();
    }

    private boolean isAlreadyIn(Control control) {
        return this.alreadyInControls.contains(control);
    }
}

