/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui.text;

import com.modeliosoft.modelio.api.Messages;
import com.modeliosoft.modelio.api.app.picking.IPickingClient;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.dnd.EditorDropListener;
import com.modeliosoft.modelio.api.ui.dnd.IEditorDropClient;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.api.ui.text.IElementChangeListener;
import com.modeliosoft.modelio.api.ui.text.IElementFilter;
import com.modeliosoft.modelio.api.ui.text.ResultsProposalPopup;
import com.modeliosoft.modelio.api.utils.UMLMetaclassName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TextWrapperForIElement
implements IPickingClient,
IEditorDropClient {
    private IElement selectedElement;
    private IElementFilter elementFilter = null;
    private boolean acceptNullValue;
    private Set<IElementChangeListener> listeners;
    private List<Class<? extends IElement>> allowedMetaclasses;
    protected Text textField;
    private KeyAdapter keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            try {
                TextWrapperForIElement.this.onKeyPressed(keyEvent);
            }
            catch (Exception exception) {
                Modelio.getInstance().getLogService().error(null, exception);
            }
        }
    };
    private FocusListener selectionListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            TextWrapperForIElement.this.startPickingSession();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    };
    protected static final Image indicatorImage;

    public boolean isAcceptNullValue() {
        return this.acceptNullValue;
    }

    public void setAcceptNullValue(boolean bl) {
        this.acceptNullValue = bl;
    }

    public void addAllowedMetaclass(Class<? extends IElement> clazz) {
        this.allowedMetaclasses.add(clazz);
        this.updateTooltip();
    }

    public boolean removeAllowedMetaclass(Class<? extends IElement> clazz) {
        boolean bl = this.allowedMetaclasses.remove(clazz);
        this.updateTooltip();
        return bl;
    }

    public void addAllowedMetaclasses(List<Class<? extends IElement>> list) {
        this.allowedMetaclasses.addAll(list);
        this.updateTooltip();
    }

    public boolean removeAllowedMetaclasses(List<Class<? extends IElement>> list) {
        boolean bl = this.allowedMetaclasses.removeAll(list);
        this.updateTooltip();
        return bl;
    }

    public List<Class<? extends IElement>> getAllowedMetaclasses() {
        return this.allowedMetaclasses;
    }

    public TextWrapperForIElement(Composite composite, IElement iElement, boolean bl, List<Class<? extends IElement>> list) {
        this.selectedElement = iElement;
        this.acceptNullValue = bl;
        this.allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
        if (list != null) {
            this.allowedMetaclasses.addAll(list);
        }
        this.createContent(composite);
    }

    public List<IElement> findByName(List<Class<? extends IElement>> list, String string, IElementFilter iElementFilter) {
        IModelingSession iModelingSession = Modelio.getInstance().getModelingSession();
        Object object = new ArrayList<IElement>();
        for (Class<? extends IElement> object2 : list) {
            object.addAll(iModelingSession.findByAtt(object2, "Name", string));
        }
        if (iElementFilter != null) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                IElement iElement = (IElement)iterator.next();
                if (!iElementFilter.accept(iElement)) continue;
                arrayList.add(iElement);
            }
            object = arrayList;
        }
        return object;
    }

    protected void onKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            ElementFinder elementFinder = new ElementFinder(Modelio.getInstance().getModelingSession());
            List<IElement> list = elementFinder.findByName(this.allowedMetaclasses, this.textField.getText(), this.elementFilter);
            if (list.isEmpty()) {
                String string = this.textField.getText() + ".*";
                list = elementFinder.search(this.allowedMetaclasses, string, this.elementFilter);
                if (list.isEmpty()) {
                    this.setContent(null);
                } else if (list.size() == 1) {
                    this.setContent(list.get(0));
                } else {
                    ResultsProposalPopup resultsProposalPopup = new ResultsProposalPopup((Control)this.textField, list, this.acceptNullValue);
                    IModelElement iModelElement = (IModelElement)resultsProposalPopup.getChoice();
                    this.setContent((IElement)iModelElement);
                }
            } else if (list.size() == 1) {
                this.setContent(list.get(0));
            } else {
                ResultsProposalPopup resultsProposalPopup = new ResultsProposalPopup((Control)this.textField, list, this.acceptNullValue);
                IModelElement iModelElement = (IModelElement)resultsProposalPopup.getChoice();
                this.setContent((IElement)iModelElement);
            }
            return;
        }
        if (keyEvent.character == ' ' && (keyEvent.stateMask & 0x40000) != 0) {
            String string = this.textField.getText() + ".*";
            ElementFinder elementFinder = new ElementFinder(Modelio.getInstance().getModelingSession());
            List<IElement> list = elementFinder.search(this.allowedMetaclasses, string, this.elementFilter);
            if (list.isEmpty()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getMessage("HybridNotFoundTitle", new String[0]), (String)Messages.getMessage("HybridNotFoundMessage", new String[0]));
                this.validate(false);
            } else if (list.size() == 1 && !this.acceptNullValue) {
                this.setContent(list.get(0));
            } else {
                ResultsProposalPopup resultsProposalPopup = new ResultsProposalPopup((Control)this.textField, list, this.acceptNullValue);
                IModelElement iModelElement = (IModelElement)resultsProposalPopup.getChoice();
                this.setContent((IElement)iModelElement);
            }
        } else if (keyEvent.character == '\u001b') {
            this.validate(false);
        }
    }

    protected void startPickingSession() {
        if (this.selectedElement != null) {
            String string = this.selectedElement.getName();
            this.textField.setText(string);
        }
        this.textField.selectAll();
        Modelio.getInstance().getPickingService().startPickingSession(this);
    }

    public void createContent(Composite composite) {
        this.textField = new Text(composite, 2048);
        this.updateTooltip();
        this.textField.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Color color;
                GC gC = paintEvent.gc;
                Rectangle rectangle = gC.getClipping();
                Rectangle rectangle2 = new Rectangle(paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
                Rectangle rectangle3 = TextWrapperForIElement.this.textField.getBounds();
                rectangle3.x = 0;
                rectangle3.y = 0;
                rectangle3.height -= 5;
                rectangle3.width -= 5;
                Display display = Display.getCurrent();
                if (TextWrapperForIElement.this.textField.isFocusControl()) {
                    color = display.getSystemColor(9);
                    gC.setForeground(color);
                    gC.setClipping(rectangle2);
                    gC.drawRectangle(rectangle3);
                    gC.setClipping(rectangle);
                }
                if (indicatorImage != null) {
                    color = indicatorImage.getBounds();
                    gC.drawImage(indicatorImage, rectangle3.x + rectangle3.width - color.width, rectangle3.y);
                }
            }
        });
        if (this.selectedElement != null) {
            String string = this.selectedElement.getName();
            if (this.selectedElement.getCompositionOwner() != null) {
                string = string + "  (from " + ((IModelElement)this.selectedElement.getCompositionOwner()).getName() + ")";
            }
            this.textField.setData((Object)this.selectedElement);
            this.textField.setText(string);
        }
        this.textField.addKeyListener((KeyListener)this.keyListener);
        this.textField.addFocusListener(this.selectionListener);
        this.initDropTarget();
    }

    private void setContent(IElement iElement) {
        if (iElement != null) {
            IModelElement iModelElement = (IModelElement)iElement;
            String string = iModelElement.getName();
            if (iModelElement.getCompositionOwner() != null) {
                string = string + "  (from " + ((IModelElement)iModelElement.getCompositionOwner()).getName() + ")";
            }
            this.textField.setData((Object)iElement);
            this.textField.setText(string);
            this.validate(true);
        } else {
            this.textField.setData(null);
            this.validate(true);
        }
    }

    @Override
    public boolean acceptElement(IElement iElement) {
        for (Class<? extends IElement> clazz : this.allowedMetaclasses) {
            if (iElement == null || !clazz.isAssignableFrom(iElement.getClass())) continue;
            return true;
        }
        return iElement == null && this.acceptNullValue;
    }

    @Override
    public boolean setElement(IElement iElement) {
        if (this.acceptElement(iElement)) {
            this.setContent(iElement);
            return true;
        }
        return false;
    }

    private void validate(boolean bl) {
        this.endPickingSession();
        if (bl) {
            IElement iElement = this.selectedElement;
            this.selectedElement = (IModelElement)this.textField.getData();
            this.fireSelectedElementChanged(iElement, this.selectedElement);
        }
    }

    private void initDropTarget() {
        EditorDropListener editorDropListener = new EditorDropListener(this);
        int n = 3;
        Transfer[] transferArray = new Transfer[]{ModelElementTransfer.getInstance(), PluginTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget((Control)this.textField, n);
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener((DropTargetListener)editorDropListener);
    }

    @Override
    public boolean acceptDroppedElements(IElement[] iElementArray) {
        if (iElementArray.length != 1) {
            return false;
        }
        for (Class<? extends IElement> clazz : this.allowedMetaclasses) {
            if (!clazz.isAssignableFrom(iElementArray[0].getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDroppedElements(IElement[] iElementArray) {
        if (this.acceptElement(iElementArray[0])) {
            this.setContent(iElementArray[0]);
        }
    }

    @Override
    public void pickingAborted() {
        this.endPickingSession();
    }

    public void setElementFilter(IElementFilter iElementFilter) {
        this.elementFilter = iElementFilter;
    }

    public void addListener(IElementChangeListener iElementChangeListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<IElementChangeListener>();
        }
        this.listeners.add(iElementChangeListener);
    }

    public void removeListener(IElementChangeListener iElementChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(iElementChangeListener);
        }
    }

    private void fireSelectedElementChanged(IElement iElement, IElement iElement2) {
        if (this.listeners != null) {
            for (IElementChangeListener iElementChangeListener : this.listeners) {
                iElementChangeListener.selectedElementChanged(iElement, iElement2);
            }
        }
    }

    public Text getTextField() {
        return this.textField;
    }

    protected void endPickingSession() {
        try {
            Modelio.getInstance().getPickingService().endPickingSession(this);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void updateTooltip() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.allowedMetaclasses.size() > 1) {
            stringBuffer.append(Messages.getMessage("AcceptedTypes", new String[0]));
        } else if (this.allowedMetaclasses.size() == 1) {
            stringBuffer.append(Messages.getMessage("AcceptedType", new String[0]));
        }
        stringBuffer.append("\n");
        for (Class<? extends IElement> clazz : this.allowedMetaclasses) {
            stringBuffer.append("    ");
            if (clazz == String.class) {
                stringBuffer.append(Messages.getMessage("AnyStringValue", new String[0]));
            } else {
                stringBuffer.append(clazz.getAnnotation(UMLMetaclassName.class).value());
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getMessage("HybridCellEditorTootip", new String[0]));
        this.textField.setToolTipText(stringBuffer.toString());
    }

    static {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.ui", (String)"icons/indicator.png");
        indicatorImage = imageDescriptor != null ? imageDescriptor.createImage() : null;
    }

    static class ElementFinder {
        private IModelingSession session;

        public ElementFinder(IModelingSession iModelingSession) {
            this.session = iModelingSession;
        }

        public List<IElement> findByName(List<Class<? extends IElement>> list, String string, IElementFilter iElementFilter) {
            Object object = new ArrayList<IElement>();
            for (Class<? extends IElement> object2 : list) {
                object.addAll(this.session.findByAtt(object2, "Name", string));
            }
            if (iElementFilter != null) {
                ArrayList arrayList = new ArrayList();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    IElement iElement = (IElement)iterator.next();
                    if (!iElementFilter.accept(iElement)) continue;
                    arrayList.add(iElement);
                }
                object = arrayList;
            }
            return object;
        }

        public List<IElement> search(List<Class<? extends IElement>> list, String string, IElementFilter iElementFilter) {
            HashSet<IElement> hashSet = new HashSet<IElement>();
            for (Class<? extends IElement> serializable2 : list) {
                hashSet.addAll(this.session.findByClass(serializable2));
            }
            IModelTree iModelTree = this.session.getModel().getUmlTypes().getBOOLEAN().getOwner();
            hashSet.remove(iModelTree);
            hashSet.remove(iModelTree.getOwner());
            ArrayList<IElement> arrayList = new ArrayList<IElement>();
            Pattern pattern = Pattern.compile(string);
            for (IElement iElement : hashSet) {
                if (!(iElement instanceof IModelElement)) continue;
                IModelElement iModelElement = (IModelElement)iElement;
                if (pattern.matcher(iModelElement.getName()).matches() && iElementFilter == null) {
                    arrayList.add(iElement);
                    continue;
                }
                if (!pattern.matcher(iModelElement.getName()).matches() || !iElementFilter.accept(iElement)) continue;
                arrayList.add(iElement);
            }
            return arrayList;
        }
    }
}

