/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.catalog;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.script.catalog.Catalog;
import com.modeliosoft.modelio.script.catalog.CatalogReader;
import com.modeliosoft.modelio.script.catalog.CatalogWriter;
import com.modeliosoft.modelio.script.i18n.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.osgi.framework.Bundle;

public class CatalogProvider
extends Observable {
    private List<Catalog> catalogs;
    private IModelingSession session;
    private File workspaceMacrosPath;
    private URI modelioMacrosPath = null;

    public CatalogProvider(IModelingSession session) {
        try {
            Bundle bundle = Platform.getBundle((String)"org.modelio.script");
            URL macrosPathUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("res/macros/"), null);
            if (macrosPathUrl != null) {
                this.modelioMacrosPath = macrosPathUrl.toURI();
            } else {
                System.err.println("Cannot find 'res/macros/' directory in '" + bundle.getSymbolicName() + "' plugin.");
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.workspaceMacrosPath = new File(O.getDefault().getWorkspacePath(), "/.config/macros");
        this.session = session;
        this.workspaceMacrosPath.mkdirs();
        this.refresh();
    }

    public List<Catalog> getCatalogs() {
        return this.catalogs;
    }

    public Observable getObservable() {
        return this;
    }

    public void refresh() {
        this.catalogs = new ArrayList();
        if (this.modelioMacrosPath != null) {
            URL catalogUrl = null;
            try {
                catalogUrl = new URL(this.modelioMacrosPath.toURL(), "scripts.catalog");
                File catalogFile = new File(FileLocator.toFileURL((URL)catalogUrl).getPath());
                Catalog c = this.readCatalog(catalogFile, Messages.getString((String)"Catalog.modelio"), this.modelioMacrosPath);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                if (catalogUrl != null) {
                    System.err.println("'" + catalogUrl.toString() + "' catalog file not found");
                } else {
                    System.err.println("'" + e.getMessage() + "' file not found");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.readCatalog(new File(this.workspaceMacrosPath, "scripts.catalog"), Messages.getString((String)"Catalog.workspace"), this.workspaceMacrosPath.toURI());
        if (this.session != null) {
            File projectMacrosPath = new File(this.session.getProjectSpacePath(), "/.config/macros");
            projectMacrosPath.mkdirs();
            this.readCatalog(new File(projectMacrosPath, "scripts.catalog"), Messages.getString((String)"Catalog.project"), projectMacrosPath.toURI());
        }
        this.setChanged();
        this.notifyObservers((Object)this);
    }

    public void save() {
        for (Catalog cat : this.getCatalogs()) {
            if (!cat.isModifiable()) continue;
            File file = new File(new File(cat.getPath()), "scripts.catalog");
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(file);
                new CatalogWriter(cat, (OutputStream)stream).execute();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (stream == null) continue;
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                continue;
            }
            catch (XMLStreamException e) {
                try {
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        try {
                            ((OutputStream)stream).close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
            }
            if (stream == null) continue;
            try {
                ((OutputStream)stream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setChanged();
        this.notifyObservers((Object)this);
    }

    private Catalog createEmptyCatalog(String catalogName, URI path) {
        Catalog cat = new Catalog(path);
        cat.setName(catalogName);
        this.catalogs.add(cat);
        return cat;
    }

    private Catalog readCatalog(File file, String catalogName, URI macrosPath) {
        if (!file.isFile()) {
            return this.createEmptyCatalog(catalogName, macrosPath);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Catalog readCatalog = new CatalogReader((InputStream)in, macrosPath).readCatalog();
            readCatalog.setName(catalogName);
            this.catalogs.add(readCatalog);
            Catalog catalog = readCatalog;
            return catalog;
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.openWarning(null, (String)Messages.getString((String)"Error"), (String)Messages.getMessage((String)"CatalogDialog.Error.CannotReadFile", (String[])new String[]{file.getPath(), e.getLocalizedMessage()}));
            Catalog catalog = this.createEmptyCatalog(catalogName, macrosPath);
            return catalog;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

