/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.catalog;

import com.modeliosoft.modelio.script.catalog.Catalog;
import com.modeliosoft.modelio.script.catalog.Script;
import com.modeliosoft.modelio.script.i18n.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CatalogReader {
    private Document doc;
    private URI path;

    public CatalogReader(InputStream in, URI path) throws IOException {
        this.path = path;
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            DocumentBuilder b = f.newDocumentBuilder();
            this.doc = b.parse(in);
            in.close();
        }
        catch (SAXParseException e) {
            throw new IOException(Messages.getMessage((String)"Catalog.Error.SAXParseException", (String[])new String[]{String.valueOf(e.getLineNumber()), String.valueOf(e.getColumnNumber()), e.getLocalizedMessage()}), e);
        }
        catch (SAXException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    public Catalog readCatalog() {
        return this.readCatalog(this.doc.getDocumentElement());
    }

    private Catalog readCatalog(Element domElement) {
        Catalog ret = new Catalog(this.path);
        NodeList childs = domElement.getChildNodes();
        int i = 0;
        int nb = childs.getLength();
        while (i < nb) {
            Node node = childs.item(i);
            if (node.getNodeName().equals("script")) {
                Script s = this.readScript(ret, (Element)node);
                ret.addScript(s);
            }
            ++i;
        }
        return ret;
    }

    private Script readScript(Catalog cat, Element domElement) {
        Script ret = new Script(cat);
        ret.setName(domElement.getAttribute("name"));
        ret.setRelativePath(URI.create(domElement.getAttribute("path")));
        ret.setShowInContextualMenu(Boolean.parseBoolean(domElement.getAttribute("show-menu")));
        ret.setShowInToolbar(Boolean.parseBoolean(domElement.getAttribute("show-toolbar")));
        String s = domElement.getAttribute("icon-path");
        if (s == null || s.isEmpty()) {
            ret.setIconRelativePath(null);
        } else {
            ret.setIconRelativePath(URI.create(s));
        }
        NodeList childs = domElement.getChildNodes();
        int i = 0;
        int nb = childs.getLength();
        while (i < nb) {
            Node node = childs.item(i);
            if (node.getNodeName().equals("description")) {
                String content = node.getTextContent();
                if (content != null) {
                    ret.setDescription(content);
                }
            } else if (node.getNodeName().equals("metaclass")) {
                String classname = ((Element)node).getAttribute("name");
                ret.addMetaclass(classname);
            }
            ++i;
        }
        return ret;
    }
}

