/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.catalog;

import com.modeliosoft.modelio.script.catalog.Catalog;
import com.modeliosoft.modelio.script.catalog.Script;
import java.io.OutputStream;
import java.net.URI;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CatalogWriter {
    OutputStream output;
    Catalog catalog;

    public CatalogWriter(Catalog c, OutputStream output) {
        this.catalog = c;
        this.output = output;
    }

    public void execute() throws XMLStreamException {
        XMLOutputFactory of = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = of.createXMLStreamWriter(this.output);
        writer.writeStartDocument();
        this.writeCatalog(this.catalog, writer);
        writer.writeEndDocument();
        writer.close();
    }

    private void writeCatalog(Catalog c, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("catalog");
        writer.writeCharacters("\n");
        for (Script s : c.getScripts()) {
            writer.writeStartElement("script");
            writer.writeAttribute("name", s.getName());
            writer.writeAttribute("path", s.getRelativePath().toString());
            writer.writeAttribute("icon-path", this.getIconRelativePath(s));
            writer.writeAttribute("show-menu", String.valueOf(s.shownInContextualMenu()));
            writer.writeAttribute("show-toolbar", String.valueOf(s.shownInToolbar()));
            writer.writeCharacters("\n");
            writer.writeStartElement("description");
            if (s.getDescription() != null) {
                writer.writeCharacters(s.getDescription());
            }
            writer.writeEndElement();
            writer.writeCharacters("\n");
            for (String metaclass : s.getMetaclasses()) {
                writer.writeStartElement("metaclass");
                writer.writeAttribute("name", metaclass);
                writer.writeEndElement();
                writer.writeCharacters("\n");
            }
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        writer.writeEndElement();
    }

    private String getIconRelativePath(Script s) {
        URI p = s.getIconRelativePath();
        if (p == null) {
            return "";
        }
        return p.toString();
    }
}

