/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.catalog;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.script.catalog.Catalog;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public class Script {
    private Catalog catalog;
    private String description = "";
    private URI iconRelativePath = null;
    private String name = "";
    private URI relativePath = null;
    private boolean showInContextualMenu;
    private boolean showInToolbar;
    private Collection<String> metaclasses = new ArrayList();

    public Script(Catalog catalog) {
        this.catalog = catalog;
    }

    public void addMetaclass(String classname) {
        this.metaclasses.add(classname);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getIconPath() {
        if (this.iconRelativePath == null) {
            return null;
        }
        return this.catalog.getPath().resolve(this.iconRelativePath);
    }

    public URI getIconRelativePath() {
        return this.iconRelativePath;
    }

    public Collection<String> getMetaclasses() {
        return this.metaclasses;
    }

    public String getName() {
        return this.name;
    }

    public URI getPath() {
        if (this.relativePath == null) {
            return null;
        }
        return this.catalog.getPath().resolve(this.relativePath);
    }

    public URI getRelativePath() {
        return this.relativePath;
    }

    public boolean isRunnableOn(Collection<IElement> selectedElements) {
        if (this.getMetaclasses().isEmpty()) {
            return true;
        }
        if (selectedElements == null || selectedElements.isEmpty()) {
            return false;
        }
        for (IElement element : selectedElements) {
            boolean ok = false;
            for (String scriptMcName : this.getMetaclasses()) {
                try {
                    Class scriptMc = MetaModelExpert.getMetaclass((String)scriptMcName);
                    if (!scriptMc.isAssignableFrom(element.getClass())) continue;
                    ok = true;
                    break;
                }
                catch (IllegalArgumentException e) {
                    LOG.error((String)"org.modelio.script", (Throwable)e);
                }
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    public void setDescription(String string) {
        if (!string.equals(this.description)) {
            this.description = string;
        }
    }

    public void setIconPath(URI newPath) {
        if (newPath == null) {
            this.setIconRelativePath(null);
        } else {
            this.setIconRelativePath(this.catalog.getPath().relativize(newPath));
        }
    }

    public void setIconRelativePath(URI iconRelativePath) {
        this.iconRelativePath = iconRelativePath;
    }

    public void setMetaclasses(Collection<String> newset) {
        this.metaclasses = new ArrayList<String>(newset);
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setPath(URI newPath) {
        this.setRelativePath(this.catalog.getPath().relativize(newPath));
    }

    public void setRelativePath(URI newPath) {
        this.relativePath = newPath;
    }

    public void setShowInContextualMenu(boolean showInContextualMenu) {
        this.showInContextualMenu = showInContextualMenu;
    }

    public void setShowInToolbar(boolean showInToolbar) {
        this.showInToolbar = showInToolbar;
    }

    public boolean shownInContextualMenu() {
        return this.showInContextualMenu;
    }

    public boolean shownInToolbar() {
        return this.showInToolbar;
    }

    public void moveTo(Catalog newCatalog) {
        URI oldPath = this.getPath();
        URI oldIconPath = this.getIconPath();
        if (this.catalog == newCatalog) {
            return;
        }
        if (this.catalog != null) {
            this.catalog.removeScript(this);
        }
        newCatalog.addScript(this);
        this.catalog = newCatalog;
        if (oldPath != null) {
            this.setPath(oldPath);
        }
        if (oldIconPath != null) {
            this.setIconPath(oldIconPath);
        }
    }
}

