/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.catalogdialog;

import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.script.catalog.CatalogProvider;
import com.modeliosoft.modelio.script.catalog.Script;
import com.modeliosoft.modelio.script.catalogdialog.CatalogContentProvider;
import com.modeliosoft.modelio.script.catalogdialog.CatalogDialog;
import com.modeliosoft.modelio.script.catalogdialog.CatalogLabelProvider;
import com.modeliosoft.modelio.script.catalogdialog.FileChooserButtonFactory;
import com.modeliosoft.modelio.script.catalogdialog.RunScriptButtonListener;
import com.modeliosoft.modelio.script.i18n.Messages;
import com.modeliosoft.modelio.script.utils.SelectionGetter;
import com.modeliosoft.modelio.script.views.ScriptView;
import com.modeliosoft.modelio.script.views.ScriptViewGetter;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CatalogDialog
extends ModelioDialog {
    Button addScriptFromFileButton;
    private CatalogProvider catalogProvider;
    private Button iconPathButton;
    private Text iconPathText;
    Table metaclassList;
    private CatalogContentProvider provider;
    Button removeScriptButton;
    Button runScriptButton;
    private Text scriptDescriptionText;
    Text scriptNameText;
    private Group scriptPanel;
    private Button scriptPathButton;
    private Text scriptPathText;
    Script selectedScript = null;
    private Button showInMenuToggle;
    private Button showInToolbarToggle;
    TreeViewer treeviewer;
    SelectionGetter selectionGetter;

    public CatalogDialog(Shell parentShell, CatalogProvider catalogProvider) {
        super(parentShell);
        if (catalogProvider == null) {
            throw new NullPointerException("catalogProvider cannot be null.");
        }
        this.catalogProvider = catalogProvider;
        this.selectionGetter = new SelectionGetter(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService());
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public Control createContentArea(Composite parent) {
        SashForm composite = new SashForm(parent, 0x100100);
        composite.setLayout((Layout)new FillLayout());
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group catalogPanel = new Group((Composite)composite, 16);
        catalogPanel.setText(Messages.getString((String)"CatalogDialog.CatalogGroup"));
        this.treeviewer = new TreeViewer((Composite)catalogPanel, 0);
        this.provider = new CatalogContentProvider(this.catalogProvider);
        CatalogLabelProvider labelProvider = new CatalogLabelProvider();
        this.treeviewer.setContentProvider((IContentProvider)this.provider);
        this.treeviewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeviewer.addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionChangedListener(this));
        Composite catalogToolbar = new Composite((Composite)catalogPanel, 0);
        GridDataFactory.defaultsFor((Control)catalogToolbar).align(0x1000008, 1).grab(false, false).applyTo((Control)catalogToolbar);
        this.addScriptFromFileButton = new Button(catalogToolbar, 8);
        this.addScriptFromFileButton.setText(Messages.getString((String)"CatalogDialog.AddScriptButton"));
        this.addScriptFromFileButton.addSelectionListener((SelectionListener)new NewMacroFromFileButtonListener(this));
        this.addScriptFromFileButton.setToolTipText(Messages.getString((String)"CatalogDialog.AddScriptButtonTooltip"));
        this.removeScriptButton = new Button(catalogToolbar, 8);
        this.removeScriptButton.setText(Messages.getString((String)"CatalogDialog.DeleteScriptButton"));
        this.removeScriptButton.addSelectionListener((SelectionListener)new DeleteMacroButtonListener(this));
        this.runScriptButton = new Button(catalogToolbar, 8);
        this.runScriptButton.setText(Messages.getString((String)"CatalogDialog.RunScriptButton"));
        this.runScriptButton.addSelectionListener((SelectionListener)new RunScriptButtonListener(this.treeviewer));
        this.runScriptButton.setToolTipText(null);
        GridLayoutFactory.fillDefaults().numColumns(4).generateLayout(catalogToolbar);
        GridLayoutFactory.swtDefaults().generateLayout((Composite)catalogPanel);
        this.scriptPanel = new Group((Composite)composite, 16);
        this.scriptPanel.setText(Messages.getString((String)"CatalogDialog.ScriptGroup"));
        Label scriptNameLabel = new Label((Composite)this.scriptPanel, 0);
        scriptNameLabel.setText(Messages.getString((String)"CatalogDialog.NameLabel"));
        this.scriptNameText = new Text((Composite)this.scriptPanel, 2052);
        Label scriptPathLabel = new Label((Composite)this.scriptPanel, 0);
        scriptPathLabel.setText(Messages.getString((String)"CatalogDialog.PathLabel"));
        Composite scriptPathGroup = new Composite((Composite)this.scriptPanel, 0);
        this.scriptPathText = new Text(scriptPathGroup, 2052);
        this.scriptPathButton = FileChooserButtonFactory.create((Composite)scriptPathGroup, (Text)this.scriptPathText, (String)"", (String[])new String[]{Messages.getString((String)"CatalogDialog.ScriptPathFilterNames")}, (String[])new String[]{Messages.getString((String)"CatalogDialog.ScriptPathFilterExtensions")});
        Image fileButtonImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        this.scriptPathButton.setImage(fileButtonImage);
        GridDataFactory.defaultsFor((Control)this.scriptPathButton).hint(fileButtonImage.getBounds().width + 4, fileButtonImage.getBounds().height + 4).applyTo((Control)this.scriptPathButton);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(scriptPathGroup);
        Label iconPathLabel = new Label((Composite)this.scriptPanel, 0);
        iconPathLabel.setText(Messages.getString((String)"CatalogDialog.IconPathLabel"));
        Composite iconPathGroup = new Composite((Composite)this.scriptPanel, 0);
        this.iconPathText = new Text(iconPathGroup, 2052);
        this.iconPathButton = FileChooserButtonFactory.create((Composite)iconPathGroup, (Text)this.iconPathText, (String)"", (String[])new String[]{Messages.getString((String)"CatalogDialog.IconPathFilterNames")}, (String[])new String[]{Messages.getString((String)"CatalogDialog.IconPathFilterExtensions")});
        this.iconPathButton.setImage(fileButtonImage);
        GridDataFactory.defaultsFor((Control)this.iconPathButton).hint(fileButtonImage.getBounds().width + 4, fileButtonImage.getBounds().height + 4).applyTo((Control)this.iconPathButton);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(iconPathGroup);
        Label scriptDescLabel = new Label((Composite)this.scriptPanel, 0);
        scriptDescLabel.setText(Messages.getString((String)"CatalogDialog.DescriptionLabel"));
        this.scriptDescriptionText = new Text((Composite)this.scriptPanel, 2626);
        Label ApplicableOnLabel = new Label((Composite)this.scriptPanel, 0);
        ApplicableOnLabel.setText(Messages.getString((String)"CatalogDialog.ApplicableOnLabel"));
        this.metaclassList = new Table((Composite)this.scriptPanel, 2048);
        this.metaclassList.addMouseListener((MouseListener)new ApplicableOnListener(this));
        this.metaclassList.setToolTipText(Messages.getString((String)"CatalogDialog.ApplicableOnTooltip"));
        this.showInMenuToggle = new Button((Composite)this.scriptPanel, 32);
        this.showInMenuToggle.setText(Messages.getString((String)"CatalogDialog.ShowInContextualMenu"));
        this.showInToolbarToggle = new Button((Composite)this.scriptPanel, 32);
        this.showInToolbarToggle.setText(Messages.getString((String)"CatalogDialog.ShowInToolbar"));
        this.updateScriptPanel(null);
        this.treeviewer.setInput((Object)1);
        this.treeviewer.refresh();
        composite.setWeights(new int[]{50, 50});
        GridLayoutFactory.swtDefaults().generateLayout((Composite)this.scriptPanel);
        return composite;
    }

    public void init() {
        this.getShell().setText(Messages.getString((String)"CatalogDialog.Title"));
        this.setTitle(Messages.getString((String)"CatalogDialog.Title"));
        this.setMessage(Messages.getString((String)"CatalogDialog.Description"));
        this.getShell().setMinimumSize(600, 400);
    }

    protected void cancelPressed() {
        this.provider.reload();
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.validateScriptPanel()) {
            this.provider.save();
        } else {
            this.provider.reload();
        }
        super.okPressed();
    }

    private void checkPath(File path) throws IllegalPathException {
        if (!path.canRead() || !path.isFile()) {
            throw new IllegalPathException(Messages.getMessage((String)"CatalogDialog.Error.FileNotReadable", (String[])new String[]{path.getPath()}));
        }
    }

    private URI getValidatedPath(String stringPath) throws IllegalPathException {
        if (stringPath == null || stringPath.isEmpty()) {
            throw new IllegalArgumentException("path must not be null nor empty.");
        }
        try {
            URI uri = new URI(stringPath);
            if (uri.getScheme().equals("file")) {
                File path = new File(uri);
                this.checkPath(path);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            File path = new File(stringPath);
            try {
                this.checkPath(path);
                return path.toURI();
            }
            catch (IllegalPathException e2) {
                throw new IllegalPathException(e.getLocalizedMessage());
            }
        }
    }

    void updateScriptPanel(Script script) {
        if (script != null) {
            this.scriptNameText.setText(script.getName());
            this.scriptDescriptionText.setText(script.getDescription());
            URI path = script.getPath();
            if (path != null) {
                this.scriptPathText.setText(path.toString());
            } else {
                this.scriptPathText.setText("");
            }
            URI iconPath = script.getIconPath();
            if (iconPath != null) {
                this.iconPathText.setText(iconPath.toString());
            } else {
                this.iconPathText.setText("");
            }
            this.metaclassList.removeAll();
            for (String s : script.getMetaclasses()) {
                this.addMetaclass(s);
            }
            this.showInMenuToggle.setSelection(script.shownInContextualMenu());
            this.showInToolbarToggle.setSelection(script.shownInToolbar());
            boolean modifiable = script.getCatalog().isModifiable();
            this.scriptNameText.setEnabled(modifiable);
            this.scriptDescriptionText.setEnabled(modifiable);
            this.scriptPathText.setEnabled(modifiable);
            this.scriptPathButton.setEnabled(modifiable);
            this.iconPathText.setEnabled(modifiable);
            this.iconPathButton.setEnabled(modifiable);
            this.metaclassList.setEnabled(modifiable);
            this.showInMenuToggle.setEnabled(modifiable);
            this.showInToolbarToggle.setEnabled(modifiable);
        } else {
            this.scriptNameText.setText("");
            this.scriptDescriptionText.setText("");
            this.scriptPathText.setText("");
            this.iconPathText.setText("");
            this.metaclassList.removeAll();
            this.showInMenuToggle.setSelection(false);
            this.showInToolbarToggle.setSelection(false);
            this.scriptNameText.setEnabled(false);
            this.scriptDescriptionText.setEnabled(false);
            this.scriptPathText.setEnabled(false);
            this.scriptPathButton.setEnabled(false);
            this.iconPathText.setEnabled(false);
            this.iconPathButton.setEnabled(false);
            this.metaclassList.setEnabled(false);
            this.showInMenuToggle.setEnabled(false);
            this.showInToolbarToggle.setEnabled(false);
        }
        this.selectedScript = script;
    }

    private boolean validateIconPath() {
        String stringPath = this.iconPathText.getText();
        if (stringPath == null || stringPath.isEmpty()) {
            this.selectedScript.setIconPath(null);
            return true;
        }
        try {
            this.selectedScript.setIconPath(this.getValidatedPath(stringPath));
        }
        catch (IllegalPathException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"Error"), (String)e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private boolean validatePath() {
        String stringPath = this.scriptPathText.getText();
        if (stringPath == null || stringPath.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"Error"), (String)Messages.getMessage((String)"CatalogDialog.Error.PathEmpty", (String[])new String[0]));
            return false;
        }
        try {
            this.selectedScript.setPath(this.getValidatedPath(stringPath));
        }
        catch (IllegalPathException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"Error"), (String)e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    boolean validateScriptPanel() {
        if (this.selectedScript != null) {
            if (!this.validatePath()) {
                return false;
            }
            if (!this.validateIconPath()) {
                return false;
            }
            this.selectedScript.setName(this.scriptNameText.getText());
            this.selectedScript.setDescription(this.scriptDescriptionText.getText().replace("\r\n", "\n"));
            this.selectedScript.setShowInContextualMenu(this.showInMenuToggle.getSelection());
            this.selectedScript.setShowInToolbar(this.showInToolbarToggle.getSelection());
            this.selectedScript.setMetaclasses(this.getApplicableMetaclasses());
            this.treeviewer.refresh();
        }
        return true;
    }

    Collection<String> getApplicableMetaclasses() {
        ArrayList<String> ret = new ArrayList<String>(this.metaclassList.getItemCount());
        TableItem[] tableItemArray = this.metaclassList.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem i = tableItemArray[n2];
            ret.add(i.getText());
            ++n2;
        }
        return ret;
    }

    private Image getMetaclassImage(String s) {
        try {
            Class metaclass = MetaModelExpert.getMetaclass((String)s);
            Image i = StandardImageService.getMetaclassImage((Class)metaclass);
            if (i == null) {
                i = StandardImageService.getMetaclassImage(IClass.class);
            }
            return i;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    void addMetaclass(String s) {
        TableItem i = new TableItem(this.metaclassList, 0);
        i.setText(s);
        i.setImage(this.getMetaclassImage(s));
    }

    String getScriptViewInput() {
        ScriptView scriptView = ScriptViewGetter.getScriptView();
        if (scriptView == null) {
            return "";
        }
        return scriptView.getInputViewContent().trim();
    }
}

