/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.catalogdialog2;

import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.script.catalog.CatalogProvider;
import com.modeliosoft.modelio.script.catalog.Script;
import com.modeliosoft.modelio.script.catalogdialog2.CatalogContentProvider;
import com.modeliosoft.modelio.script.catalogdialog2.CatalogDialog2;
import com.modeliosoft.modelio.script.catalogdialog2.CatalogLabelProvider;
import com.modeliosoft.modelio.script.catalogdialog2.RunScriptButtonListener;
import com.modeliosoft.modelio.script.i18n.Messages;
import com.modeliosoft.modelio.script.utils.SelectionGetter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CatalogDialog2
extends ModelioDialog {
    private Button addMacroFromFileButton;
    private CatalogProvider catalogProvider;
    private Button editMacroButton;
    private CatalogContentProvider provider;
    private Button removeScriptButton;
    private Button runScriptButton;
    private Script selectedScript = null;
    private SelectionGetter selectionGetter;
    private TreeViewer treeviewer;

    public CatalogDialog2(Shell parentShell, CatalogProvider catalogProvider) {
        super(parentShell);
        if (catalogProvider == null) {
            throw new NullPointerException("catalogProvider cannot be null.");
        }
        this.catalogProvider = catalogProvider;
        this.selectionGetter = new SelectionGetter(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService());
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public Control createContentArea(Composite parent) {
        Group catalogPanel = new Group(parent, 16);
        catalogPanel.setText(Messages.getString((String)"CatalogDialog.CatalogGroup"));
        catalogPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeviewer = new TreeViewer((Composite)catalogPanel, 0);
        this.provider = new CatalogContentProvider(this.catalogProvider);
        CatalogLabelProvider labelProvider = new CatalogLabelProvider();
        this.treeviewer.setContentProvider((IContentProvider)this.provider);
        this.treeviewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeviewer.addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionChangedListener(this, null));
        Composite catalogToolbar = new Composite((Composite)catalogPanel, 0);
        GridDataFactory.defaultsFor((Control)catalogToolbar).align(0x1000008, 1).grab(false, false).applyTo((Control)catalogToolbar);
        this.addMacroFromFileButton = new Button(catalogToolbar, 8);
        this.addMacroFromFileButton.setText(Messages.getString((String)"CatalogDialog.AddScriptButton"));
        this.addMacroFromFileButton.addSelectionListener((SelectionListener)new NewMacroFromFileButtonListener(this, null));
        this.addMacroFromFileButton.setToolTipText(Messages.getString((String)"CatalogDialog.AddScriptButtonTooltip"));
        this.editMacroButton = new Button(catalogToolbar, 8);
        this.editMacroButton.setText(Messages.getString((String)"CatalogDialog.EditMacroButton"));
        this.editMacroButton.addSelectionListener((SelectionListener)new EditMacroButtonListener(this, null));
        this.editMacroButton.setToolTipText(Messages.getString((String)"CatalogDialog.EditMacroButtonTooltip"));
        this.removeScriptButton = new Button(catalogToolbar, 8);
        this.removeScriptButton.setText(Messages.getString((String)"CatalogDialog.DeleteScriptButton"));
        this.removeScriptButton.addSelectionListener((SelectionListener)new DeleteMacroButtonListener(this, null));
        this.runScriptButton = new Button(catalogToolbar, 8);
        this.runScriptButton.setText(Messages.getString((String)"CatalogDialog.RunScriptButton"));
        this.runScriptButton.addSelectionListener((SelectionListener)new RunScriptButtonListener(this.treeviewer));
        this.runScriptButton.setToolTipText(null);
        GridLayoutFactory.fillDefaults().numColumns(4).generateLayout(catalogToolbar);
        GridLayoutFactory.swtDefaults().generateLayout((Composite)catalogPanel);
        this.treeviewer.setInput((Object)1);
        this.treeviewer.refresh();
        return catalogPanel;
    }

    public Button getEditMacroButton() {
        return this.editMacroButton;
    }

    public void init() {
        this.getShell().setText(Messages.getString((String)"CatalogDialog.Title"));
        this.setTitle(Messages.getString((String)"CatalogDialog.Title"));
        this.setMessage(Messages.getString((String)"CatalogDialog.Description"));
        this.getShell().setMinimumSize(600, 400);
    }

    protected void cancelPressed() {
        this.provider.reload();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.provider.save();
        super.okPressed();
    }

    static /* synthetic */ Script access$0(CatalogDialog2 catalogDialog2) {
        return catalogDialog2.selectedScript;
    }

    static /* synthetic */ TreeViewer access$1(CatalogDialog2 catalogDialog2) {
        return catalogDialog2.treeviewer;
    }

    static /* synthetic */ Button access$2(CatalogDialog2 catalogDialog2) {
        return catalogDialog2.removeScriptButton;
    }

    static /* synthetic */ Button access$3(CatalogDialog2 catalogDialog2) {
        return catalogDialog2.runScriptButton;
    }

    static /* synthetic */ SelectionGetter access$4(CatalogDialog2 catalogDialog2) {
        return catalogDialog2.selectionGetter;
    }

    static /* synthetic */ Button access$5(CatalogDialog2 catalogDialog2) {
        return catalogDialog2.addMacroFromFileButton;
    }

    static /* synthetic */ Button access$6(CatalogDialog2 catalogDialog2) {
        return catalogDialog2.editMacroButton;
    }

    static /* synthetic */ void access$7(CatalogDialog2 catalogDialog2, Script script) {
        catalogDialog2.selectedScript = script;
    }

    static /* synthetic */ CatalogProvider access$8(CatalogDialog2 catalogDialog2) {
        return catalogDialog2.catalogProvider;
    }
}

