/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.catalogdialog2;

import com.modeliosoft.modelio.script.catalog.Catalog;
import com.modeliosoft.modelio.script.catalog.Script;
import com.modeliosoft.modelio.script.i18n.Messages;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

class CatalogLabelProvider
extends LabelProvider {
    private static final String CATALOGID = "catalog";
    private ImageRegistry images = new ImageRegistry(Display.getDefault());

    public void dispose() {
        this.images.dispose();
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Catalog) {
            return this.images.get(CATALOGID);
        }
        if (element instanceof Script) {
            Script s = (Script)element;
            return this.getImageFromPath(s.getIconPath());
        }
        return null;
    }

    public String getText(Object element) {
        if (element == null) {
            return "<null>";
        }
        if (element instanceof Catalog) {
            Catalog cat = (Catalog)element;
            if (cat.isModifiable()) {
                return cat.getName();
            }
            return String.valueOf(cat.getName()) + " " + Messages.getString((String)"CatalogDialog.CatalogReadOnly");
        }
        if (element instanceof Script) {
            return ((Script)element).getName();
        }
        return element.toString();
    }

    CatalogLabelProvider() {
        Bundle bundle = Platform.getBundle((String)"org.modelio.script");
        URL catalogImageUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/scriptcatalog_16.png"), null);
        this.images.put(CATALOGID, ImageDescriptor.createFromURL((URL)catalogImageUrl));
    }

    private Image getImageFromPath(URI uri) {
        if (uri == null) {
            return null;
        }
        Image ret = this.images.get(uri.toString());
        if (ret == null) {
            try {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)uri.toURL());
                this.images.put(uri.toString(), desc);
                ret = this.images.get(uri.toString());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }
}

