/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.catalogdialog2;

import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.script.catalog.Catalog;
import com.modeliosoft.modelio.script.catalog.CatalogProvider;
import com.modeliosoft.modelio.script.catalog.Script;
import com.modeliosoft.modelio.script.catalogdialog2.FileChooserButtonFactory;
import com.modeliosoft.modelio.script.catalogdialog2.MacroDialog;
import com.modeliosoft.modelio.script.i18n.Messages;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MacroDialog
extends ModelioDialog {
    private Combo catalogCombo;
    private CatalogProvider catalogProvider;
    private Script editedScript = null;
    private Button iconPathButton;
    private Text iconPathText;
    Table metaclassList;
    private Text scriptDescriptionText;
    private Text scriptNameText;
    private Button scriptPathButton;
    private Text scriptPathText;
    private Button showInMenuToggle;
    private Button showInToolbarToggle;

    public MacroDialog(Shell parentShell, CatalogProvider catalogProvider, Script macroToEdit) {
        super(parentShell);
        if (catalogProvider == null) {
            throw new NullPointerException("catalogProvider cannot be null.");
        }
        this.catalogProvider = catalogProvider;
        this.editedScript = macroToEdit;
    }

    public MacroDialog(Shell parentShell, CatalogProvider catalogProvider) {
        super(parentShell);
        if (catalogProvider == null) {
            throw new NullPointerException("catalogProvider cannot be null.");
        }
        this.catalogProvider = catalogProvider;
        this.editedScript = null;
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public Control createContentArea(Composite parent) {
        Composite scriptPanel = new Composite(parent, 0);
        scriptPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        Label scriptCatLabel = new Label(scriptPanel, 0);
        scriptCatLabel.setText(Messages.getString((String)"CatalogDialog.CatalogLabel"));
        this.catalogCombo = new Combo(scriptPanel, 4);
        for (Catalog c : this.catalogProvider.getCatalogs()) {
            if (!c.isModifiable() && (this.editedScript == null || this.editedScript.getCatalog() != c)) continue;
            this.catalogCombo.add(c.getName());
            this.catalogCombo.setData(c.getName(), (Object)c);
        }
        Label scriptNameLabel = new Label(scriptPanel, 0);
        scriptNameLabel.setText(Messages.getString((String)"CatalogDialog.NameLabel"));
        this.scriptNameText = new Text(scriptPanel, 2052);
        Label scriptPathLabel = new Label(scriptPanel, 0);
        scriptPathLabel.setText(Messages.getString((String)"CatalogDialog.PathLabel"));
        Composite scriptPathGroup = new Composite(scriptPanel, 0);
        this.scriptPathText = new Text(scriptPathGroup, 2052);
        this.scriptPathButton = FileChooserButtonFactory.create((Composite)scriptPathGroup, (Text)this.scriptPathText, (String)"", (String[])new String[]{Messages.getString((String)"CatalogDialog.ScriptPathFilterNames")}, (String[])new String[]{Messages.getString((String)"CatalogDialog.ScriptPathFilterExtensions")});
        Image fileButtonImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        this.scriptPathButton.setImage(fileButtonImage);
        GridDataFactory.defaultsFor((Control)this.scriptPathButton).hint(fileButtonImage.getBounds().width + 4, fileButtonImage.getBounds().height + 4).applyTo((Control)this.scriptPathButton);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(scriptPathGroup);
        Label iconPathLabel = new Label(scriptPanel, 0);
        iconPathLabel.setText(Messages.getString((String)"CatalogDialog.IconPathLabel"));
        Composite iconPathGroup = new Composite(scriptPanel, 0);
        this.iconPathText = new Text(iconPathGroup, 2052);
        this.iconPathButton = FileChooserButtonFactory.create((Composite)iconPathGroup, (Text)this.iconPathText, (String)"", (String[])new String[]{Messages.getString((String)"CatalogDialog.IconPathFilterNames")}, (String[])new String[]{Messages.getString((String)"CatalogDialog.IconPathFilterExtensions")});
        this.iconPathButton.setImage(fileButtonImage);
        GridDataFactory.defaultsFor((Control)this.iconPathButton).hint(fileButtonImage.getBounds().width + 4, fileButtonImage.getBounds().height + 4).applyTo((Control)this.iconPathButton);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(iconPathGroup);
        Label scriptDescLabel = new Label(scriptPanel, 0);
        scriptDescLabel.setText(Messages.getString((String)"CatalogDialog.DescriptionLabel"));
        this.scriptDescriptionText = new Text(scriptPanel, 2626);
        Label ApplicableOnLabel = new Label(scriptPanel, 0);
        ApplicableOnLabel.setText(Messages.getString((String)"CatalogDialog.ApplicableOnLabel"));
        this.metaclassList = new Table(scriptPanel, 2048);
        this.metaclassList.addMouseListener((MouseListener)new ApplicableOnListener(this));
        this.metaclassList.setToolTipText(Messages.getString((String)"CatalogDialog.ApplicableOnTooltip"));
        this.showInMenuToggle = new Button(scriptPanel, 32);
        this.showInMenuToggle.setText(Messages.getString((String)"CatalogDialog.ShowInContextualMenu"));
        this.showInToolbarToggle = new Button(scriptPanel, 32);
        this.showInToolbarToggle.setText(Messages.getString((String)"CatalogDialog.ShowInToolbar"));
        this.updateFields(this.editedScript);
        GridLayoutFactory.swtDefaults().generateLayout(scriptPanel);
        return scriptPanel;
    }

    public Combo getCatalogCombo() {
        return this.catalogCombo;
    }

    public Script getScript() {
        return this.editedScript;
    }

    public void init() {
        this.getShell().setText(Messages.getString((String)"MacroDialog.Title"));
        this.setTitle(Messages.getString((String)"MacroDialog.Title"));
        this.setMessage(Messages.getString((String)"MacroDialog.Description"));
        this.getShell().setMinimumSize(600, 400);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void okPressed() {
        this.validateScriptPanel();
        super.okPressed();
    }

    void addMetaclass(String s) {
        TableItem i = new TableItem(this.metaclassList, 0);
        i.setText(s);
        i.setImage(this.getMetaclassImage(s));
    }

    private void checkPath(File path) throws IllegalPathException {
        if (!path.canRead() || !path.isFile()) {
            throw new IllegalPathException(Messages.getMessage((String)"CatalogDialog.Error.FileNotReadable", (String[])new String[]{path.getPath()}));
        }
    }

    Collection<String> getApplicableMetaclasses() {
        ArrayList<String> ret = new ArrayList<String>(this.metaclassList.getItemCount());
        TableItem[] tableItemArray = this.metaclassList.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem i = tableItemArray[n2];
            ret.add(i.getText());
            ++n2;
        }
        return ret;
    }

    private Image getMetaclassImage(String s) {
        try {
            Class metaclass = MetaModelExpert.getMetaclass((String)s);
            Image i = StandardImageService.getMetaclassImage((Class)metaclass);
            if (i == null) {
                i = StandardImageService.getMetaclassImage(IClass.class);
            }
            return i;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private URI getValidatedPath(String stringPath) throws IllegalPathException {
        if (stringPath == null || stringPath.isEmpty()) {
            throw new IllegalArgumentException("path must not be null nor empty.");
        }
        try {
            URI uri = new URI(stringPath);
            if (uri.getScheme() != null) {
                if (uri.getScheme().equals("file")) {
                    File path = new File(uri);
                    this.checkPath(path);
                }
            } else {
                File path = new File(stringPath);
                try {
                    this.checkPath(path);
                    return path.toURI();
                }
                catch (IllegalPathException e2) {
                    throw new IllegalPathException(e2.getLocalizedMessage());
                }
            }
            return uri;
        }
        catch (URISyntaxException e) {
            File path = new File(stringPath);
            try {
                this.checkPath(path);
                return path.toURI();
            }
            catch (IllegalPathException e2) {
                throw new IllegalPathException(e.getLocalizedMessage());
            }
        }
    }

    private void updateFields(Script script) {
        if (script != null) {
            this.updateCatalogCombo();
            this.scriptNameText.setText(script.getName());
            this.scriptDescriptionText.setText(script.getDescription());
            URI path = script.getPath();
            if (path != null) {
                this.scriptPathText.setText(path.toString());
            } else {
                this.scriptPathText.setText("");
            }
            URI iconPath = script.getIconPath();
            if (iconPath != null) {
                this.iconPathText.setText(iconPath.toString());
            } else {
                this.iconPathText.setText("");
            }
            this.metaclassList.removeAll();
            for (String s : script.getMetaclasses()) {
                this.addMetaclass(s);
            }
            this.showInMenuToggle.setSelection(script.shownInContextualMenu());
            this.showInToolbarToggle.setSelection(script.shownInToolbar());
            boolean modifiable = script.getCatalog().isModifiable();
            this.scriptNameText.setEnabled(modifiable);
            this.scriptDescriptionText.setEnabled(modifiable);
            this.scriptPathText.setEnabled(modifiable);
            this.scriptPathButton.setEnabled(modifiable);
            this.iconPathText.setEnabled(modifiable);
            this.iconPathButton.setEnabled(modifiable);
            this.metaclassList.setEnabled(modifiable);
            this.showInMenuToggle.setEnabled(modifiable);
            this.showInToolbarToggle.setEnabled(modifiable);
        } else {
            this.scriptNameText.setText("");
            this.scriptDescriptionText.setText("");
            this.scriptPathText.setText("");
            this.iconPathText.setText("");
            this.metaclassList.removeAll();
            this.showInMenuToggle.setSelection(false);
            this.showInToolbarToggle.setSelection(false);
            this.scriptNameText.setEnabled(true);
            this.scriptDescriptionText.setEnabled(true);
            this.scriptPathText.setEnabled(true);
            this.scriptPathButton.setEnabled(true);
            this.iconPathText.setEnabled(true);
            this.iconPathButton.setEnabled(true);
            this.metaclassList.setEnabled(true);
            this.showInMenuToggle.setEnabled(true);
            this.showInToolbarToggle.setEnabled(true);
        }
        this.editedScript = script;
    }

    private boolean validateIconPath() {
        String stringPath = this.iconPathText.getText();
        if (stringPath == null || stringPath.isEmpty()) {
            this.editedScript.setIconPath(null);
            return true;
        }
        try {
            this.editedScript.setIconPath(this.getValidatedPath(stringPath));
        }
        catch (IllegalPathException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"Error"), (String)e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private boolean validatePath() {
        String stringPath = this.scriptPathText.getText();
        if (stringPath == null || stringPath.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"Error"), (String)Messages.getMessage((String)"CatalogDialog.Error.PathEmpty", (String[])new String[0]));
            return false;
        }
        try {
            this.editedScript.setPath(this.getValidatedPath(stringPath));
        }
        catch (IllegalPathException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"Error"), (String)e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private boolean validateScriptPanel() {
        Catalog oldCatalog;
        String newCatName = this.catalogCombo.getItem(this.catalogCombo.getSelectionIndex());
        Catalog newCatalog = (Catalog)this.catalogCombo.getData(newCatName);
        if (newCatalog == null) {
            return false;
        }
        if (this.editedScript == null) {
            this.editedScript = new Script(newCatalog);
        }
        if ((oldCatalog = this.editedScript.getCatalog()) != newCatalog) {
            this.editedScript.moveTo(newCatalog);
        }
        if (!this.validatePath()) {
            return false;
        }
        if (!this.validateIconPath()) {
            return false;
        }
        this.editedScript.setName(this.scriptNameText.getText());
        this.editedScript.setDescription(this.scriptDescriptionText.getText().replace("\r\n", "\n"));
        this.editedScript.setShowInContextualMenu(this.showInMenuToggle.getSelection());
        this.editedScript.setShowInToolbar(this.showInToolbarToggle.getSelection());
        this.editedScript.setMetaclasses(this.getApplicableMetaclasses());
        return true;
    }

    private void updateCatalogCombo() {
        Catalog cat = this.editedScript.getCatalog();
        int i = 0;
        while (i < this.catalogCombo.getItemCount()) {
            String s = this.catalogCombo.getItem(i);
            if (this.catalogCombo.getData(s) == cat) {
                this.catalogCombo.select(i);
                break;
            }
            ++i;
        }
    }
}

