/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.catalogdialog2;

import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.script.catalogdialog2.MetaclassChooserDialog;
import com.modeliosoft.modelio.script.i18n.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class MetaclassChooserDialog
extends ModelioDialog {
    private Table leftTree;
    private Table rightTree;
    private Button addButton;
    private Button removeButton;
    private List<String> leftValues = new ArrayList();
    private List<String> rightValues = new ArrayList();

    void handleAdd() {
        TableItem[] tableItemArray = this.leftTree.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem i = tableItemArray[n2];
            String val = i.getText();
            this.leftValues.remove(val);
            this.rightValues.add(val);
            Collections.sort(this.leftValues);
            Collections.sort(this.rightValues);
            TableItem rightItem = new TableItem(this.rightTree, 0, this.rightValues.indexOf(val));
            rightItem.setText(val);
            rightItem.setImage(i.getImage());
            i.dispose();
            ++n2;
        }
    }

    void handleRemove() {
        TableItem[] tableItemArray = this.rightTree.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem i = tableItemArray[n2];
            String val = i.getText();
            this.rightValues.remove(val);
            this.leftValues.add(val);
            Collections.sort(this.leftValues);
            Collections.sort(this.rightValues);
            TableItem rightItem = new TableItem(this.leftTree, 0, this.leftValues.indexOf(val));
            rightItem.setText(val);
            rightItem.setImage(i.getImage());
            i.dispose();
            ++n2;
        }
    }

    public Collection<String> getSelection() {
        return this.rightValues;
    }

    public MetaclassChooserDialog(Shell parentShell, Collection<String> initValues) {
        super(parentShell);
        this.leftValues.addAll(CompositionExpert.getMetaclasses((String)"Element"));
        this.rightValues.addAll(initValues);
        Collections.sort(this.leftValues);
        Collections.sort(this.rightValues);
    }

    public void update() {
        TableItem item;
        this.leftTree.removeAll();
        this.rightTree.removeAll();
        for (String s : this.leftValues) {
            item = new TableItem(this.leftTree, 0);
            item.setText(s);
            item.setImage(this.getMetaclassImage(s));
        }
        for (String s : this.rightValues) {
            item = new TableItem(this.rightTree, 0);
            item.setText(s);
            item.setImage(this.getMetaclassImage(s));
        }
    }

    private Image getMetaclassImage(String s) {
        try {
            Class metaclass = MetaModelExpert.getMetaclass((String)s);
            Image i = StandardImageService.getMetaclassImage((Class)metaclass);
            if (i == null) {
                i = StandardImageService.getMetaclassImage(IClass.class);
            }
            return i;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public Control createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.defaultsFor((Control)composite).grab(true, true).applyTo((Control)composite);
        this.leftTree = new Table(composite, 67586);
        this.leftTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttonsGroup = new Composite(composite, 0);
        new Composite(buttonsGroup, 0);
        this.addButton = new Button(buttonsGroup, 8);
        this.removeButton = new Button(buttonsGroup, 8);
        new Composite(buttonsGroup, 0);
        GridLayoutFactory.swtDefaults().generateLayout(buttonsGroup);
        this.addButton.addSelectionListener((SelectionListener)new AddButtonSelectionListener(this));
        this.addButton.setText(Messages.getString((String)"MetaclassChooserDialog.AddButton"));
        this.removeButton.addSelectionListener((SelectionListener)new RemoveButtonSelectionListener(this));
        this.removeButton.setText(Messages.getString((String)"MetaclassChooserDialog.RemoveButton"));
        this.rightTree = new Table(composite, 67586);
        this.rightTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.update();
        GridLayoutFactory.swtDefaults().numColumns(3).generateLayout(composite);
        return composite;
    }

    public void init() {
        this.getShell().setText(Messages.getString((String)"MetaclassChooserDialog.Title"));
        this.setTitle(Messages.getString((String)"MetaclassChooserDialog.Title"));
        this.setMessage(Messages.getString((String)"MetaclassChooserDialog.Description"));
        this.getShell().setMinimumSize(600, 400);
    }
}

