/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.catalogdialog2;

import com.modeliosoft.modelio.script.catalog.Script;
import com.modeliosoft.modelio.script.engine.IScriptView;
import com.modeliosoft.modelio.script.engine.ScriptRunnerFactory;
import com.modeliosoft.modelio.script.i18n.Messages;
import com.modeliosoft.modelio.script.views.ScriptView;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;

class RunScriptButtonListener
implements SelectionListener {
    private TreeViewer treeviewer;

    public RunScriptButtonListener(TreeViewer treeviewer) {
        this.treeviewer = treeviewer;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        ISelection iSelection = this.treeviewer.getSelection();
        Object selection = ((IStructuredSelection)iSelection).getFirstElement();
        if (selection instanceof Script) {
            Script script = (Script)selection;
            URI uri = script.getPath();
            try {
                URI localUri = FileLocator.toFileURL((URL)uri.toURL()).toURI();
                ScriptView scriptView = ScriptView.Show((int)3);
                ScriptRunnerFactory.getInstance().getScriptRunner().runFile(new File(localUri), (IScriptView)scriptView);
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
                MessageDialog.openError((Shell)this.treeviewer.getControl().getShell(), (String)Messages.getString((String)"Error"), (String)Messages.getMessage((String)"RunScriptButtonListener.MalformedURLException", (String[])new String[]{uri.toString(), e1.getLocalizedMessage()}));
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
                MessageDialog.openError((Shell)this.treeviewer.getControl().getShell(), (String)Messages.getString((String)"Error"), (String)Messages.getMessage((String)"RunScriptButtonListener.URISyntaxException", (String[])new String[]{uri.toString(), e1.getLocalizedMessage()}));
            }
            catch (IOException e1) {
                e1.printStackTrace();
                MessageDialog.openError((Shell)this.treeviewer.getControl().getShell(), (String)Messages.getString((String)"Error"), (String)Messages.getMessage((String)"RunScriptButtonListener.IOException", (String[])new String[]{uri.toString(), e1.getLocalizedMessage()}));
            }
        }
    }
}

