/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.handlers;

import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.script.i18n.Messages;
import com.modeliosoft.modelio.script.views.ScriptViewGetter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LoadFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell parent = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            parent = window.getShell();
        }
        FileDialog dlg = new FileDialog(parent, 4096);
        dlg.setFilterExtensions(new String[]{"*.py; *.jy"});
        dlg.setFilterNames(new String[]{"Python files"});
        dlg.setFilterPath(new File(O.getDefault().getWorkspacePath(), "macro").getPath());
        String s = dlg.open();
        if (s != null) {
            File f = new File(s);
            try {
                String content = this.readFully(new FileReader(f));
                ScriptViewGetter.getScriptView().getInputView().append(content);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)parent, (String)Messages.getMessage((String)"Error", (String[])new String[0]), (String)Messages.getMessage((String)"FileNotFound", (String[])new String[]{f.getPath()}));
            }
            catch (IOException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)parent, (String)Messages.getMessage((String)"Error", (String[])new String[0]), (String)Messages.getMessage((String)"CannotLoadFile", (String[])new String[]{f.getPath(), e.getLocalizedMessage()}));
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    private String readFully(FileReader reader) throws IOException {
        int numChars;
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
            buf.append(arr, 0, numChars);
        }
        return buf.toString();
    }
}

