/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.handlers;

import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.script.i18n.Messages;
import com.modeliosoft.modelio.script.views.ScriptView;
import com.modeliosoft.modelio.script.views.ScriptViewGetter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class SaveScriptHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ScriptView scriptView = ScriptViewGetter.getScriptView();
        String content = scriptView.getInputView().getText();
        if (content == null || content.isEmpty()) {
            return null;
        }
        Shell parent = null;
        IWorkbenchWindow window = scriptView.getSite().getWorkbenchWindow();
        if (window != null) {
            parent = window.getShell();
        }
        FileDialog dlg = new FileDialog(parent, 8192);
        dlg.setFilterExtensions(new String[]{"*.py; *.jy"});
        dlg.setFilterNames(new String[]{"Python files"});
        dlg.setFilterPath(new File(O.getDefault().getWorkspacePath(), "macro").getPath());
        String s = dlg.open();
        if (s != null) {
            try {
                new FileWriter(s, false).append(content).close();
            }
            catch (IOException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)parent, (String)Messages.getMessage((String)"Error", (String[])new String[0]), (String)Messages.getMessage((String)"CannotSaveFile", (String[])new String[]{s, e.getLocalizedMessage()}));
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }
}

