/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.menus;

import com.modeliosoft.modelio.script.catalog.Catalog;
import com.modeliosoft.modelio.script.catalog.CatalogProvider;
import com.modeliosoft.modelio.script.catalog.CatalogProviderFactory;
import com.modeliosoft.modelio.script.catalog.Script;
import com.modeliosoft.modelio.script.engine.ScriptRunner;
import com.modeliosoft.modelio.script.engine.ScriptRunnerFactory;
import com.modeliosoft.modelio.script.i18n.Messages;
import com.modeliosoft.modelio.script.menus.OpenRunScriptDialogAction;
import com.modeliosoft.modelio.script.menus.RunScriptAction;
import com.modeliosoft.modelio.script.utils.SelectionGetter;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Bundle;

public class MacrosSubMenuContributionItem
extends ContributionItem
implements IWorkbenchContribution {
    private String text;
    private ScriptRunner scriptRunner;
    private SelectionGetter selectionGetter = null;
    private LocalResourceManager localManager;
    private MenuItem menuItem = null;
    private Bundle bundle = Platform.getBundle((String)"org.modelio.script");

    public MacrosSubMenuContributionItem() {
        this.scriptRunner = ScriptRunnerFactory.getInstance().getScriptRunner();
        this.text = Messages.getMessage((String)"Menus.MacrosSubMenu.Label", (String[])new String[0]);
        this.localManager = new LocalResourceManager(JFaceResources.getResources());
    }

    public boolean isEnabled() {
        return this.scriptRunner != null;
    }

    public boolean isVisible() {
        if (this.scriptRunner == null) {
            return false;
        }
        Collection selection = this.selectionGetter.getSelectedElements();
        return !selection.isEmpty() || this.selectionGetter.getSelection() == null;
    }

    public void dispose() {
        this.localManager.dispose();
        if (this.menuItem != null) {
            this.menuItem.dispose();
        }
        super.dispose();
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isDynamic() {
        return true;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.selectionGetter = new SelectionGetter(serviceLocator);
    }

    public void fill(Menu parentMenu, int index) {
        if (this.scriptRunner == null) {
            return;
        }
        Collection selection = this.selectionGetter.getSelectedElements();
        if (selection.isEmpty() && this.selectionGetter.getSelection() != null) {
            return;
        }
        if (this.menuItem != null) {
            this.menuItem.dispose();
        }
        URL imageUrl = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/scriptcatalog_16.png"), null);
        this.menuItem = new MenuItem(parentMenu, 64, index);
        this.menuItem.setText(this.text);
        this.menuItem.setImage(this.localManager.createImage(ImageDescriptor.createFromURL((URL)imageUrl)));
        Menu menu = new Menu(this.menuItem);
        this.menuItem.setMenu(menu);
        CatalogProvider prov = CatalogProviderFactory.getInstance().get();
        if (prov == null) {
            return;
        }
        boolean added = false;
        for (Catalog cat : prov.getCatalogs()) {
            for (Script s : cat.getScripts()) {
                if (!s.shownInContextualMenu() || !s.isRunnableOn(selection)) continue;
                this.addRunScriptItem(menu, s);
                added = true;
            }
        }
        if (added) {
            new MenuItem(menu, 2);
        }
        OpenRunScriptDialogAction action = new OpenRunScriptDialogAction();
        action.setText(Messages.getMessage((String)"Menus.RunScriptDialogAction.Label", (String[])new String[0]));
        action.setToolTipText(Messages.getMessage((String)"Menus.RunScriptDialogAction.ToolTip", (String[])new String[0]));
        imageUrl = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/scriptcatalog_16.png"), null);
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)imageUrl));
        new ActionContributionItem((IAction)action).fill(menu, -1);
    }

    private void addRunScriptItem(Menu menu, Script s) {
        new ActionContributionItem((IAction)new RunScriptAction(s, this.scriptRunner)).fill(menu, -1);
    }
}

