/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.menus;

import com.modeliosoft.modelio.script.catalog.Script;
import com.modeliosoft.modelio.script.engine.IScriptView;
import com.modeliosoft.modelio.script.engine.ScriptRunner;
import com.modeliosoft.modelio.script.i18n.Messages;
import com.modeliosoft.modelio.script.views.ScriptView;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

class RunScriptAction
extends Action {
    private Script script;
    private ScriptRunner runner;

    public RunScriptAction(Script script, ScriptRunner runner) {
        this.script = script;
        this.runner = runner;
        if (runner == null) {
            throw new IllegalArgumentException("runner must not be null");
        }
        ImageDescriptor i = this.computeImageDescriptor();
        if (i != null) {
            this.setImageDescriptor(i);
        }
    }

    private ImageDescriptor computeImageDescriptor() {
        URI uri = this.script.getIconPath();
        if (uri == null) {
            return null;
        }
        try {
            return ImageDescriptor.createFromURL((URL)uri.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return ImageDescriptor.getMissingImageDescriptor();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void run() {
        try {
            URL localUrl = FileLocator.toFileURL((URL)this.script.getPath().toURL());
            File f = new File(new URI(localUrl.toString().replace(" ", "%20")));
            ScriptView v = ScriptView.Show((int)3);
            this.runner.runFile(f, (IScriptView)v);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public String getText() {
        return this.script.getName();
    }

    public String getDescription() {
        return this.script.getDescription();
    }

    public String getToolTipText() {
        return Messages.getMessage((String)"RunScriptAction.Tooltip", (String[])new String[]{this.script.getName(), this.script.getDescription()});
    }
}

