/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.menus;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.script.catalog.Catalog;
import com.modeliosoft.modelio.script.catalog.CatalogProvider;
import com.modeliosoft.modelio.script.catalog.Script;
import com.modeliosoft.modelio.script.engine.ScriptRunner;
import com.modeliosoft.modelio.script.i18n.Messages;
import com.modeliosoft.modelio.script.menus.RunScriptAction;
import com.modeliosoft.modelio.script.menus.ToolbarAdvisor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Observer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.framework.Bundle;

public class ToolbarAdvisor
implements INullSelectionListener {
    ToolBarManager toolbarManager;
    ICoolBarManager modelioCoolbarManager;
    private ToolBarContributionItem toolbarItem;
    private IWorkbenchWindow workbenchWindow;
    private CatalogProvider catalogProvider;
    private ScriptRunner scriptRunner;
    private Observer observer;
    private Bundle bundle = Platform.getBundle((String)"org.modelio.script");

    public ToolbarAdvisor(IWorkbenchWindow workbenchWindow, CatalogProvider catalogProvider, ScriptRunner scriptRunner) {
        this.scriptRunner = scriptRunner;
        this.catalogProvider = catalogProvider;
        this.workbenchWindow = workbenchWindow;
        this.modelioCoolbarManager = O.getDefault().getActionBars().getCoolBarManager();
        this.toolbarManager = new ToolBarManager(8520000);
        this.toolbarItem = new ToolBarContributionItem((IToolBarManager)this.toolbarManager, null);
        this.modelioCoolbarManager.add((IContributionItem)this.toolbarItem);
        this.workbenchWindow.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.refresh();
        this.observer = new /* Unavailable Anonymous Inner Class!! */;
        this.catalogProvider.getObservable().addObserver(this.observer);
    }

    private void refresh() {
        this.selectionChanged(null, this.workbenchWindow.getSelectionService().getSelection());
    }

    public void dispose() {
        this.workbenchWindow.getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.catalogProvider.getObservable().deleteObserver(this.observer);
        this.modelioCoolbarManager.remove((IContributionItem)this.toolbarItem);
        this.toolbarItem.dispose();
        this.modelioCoolbarManager.update(true);
        this.observer = null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection newSelection) {
        if (newSelection == null) {
            return;
        }
        if (newSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)newSelection;
            ArrayList<IElement> selectedElements = new ArrayList<IElement>(structuredSelection.size());
            for (Object selectionElement : structuredSelection.toList()) {
                IAdaptable selectedAdapter;
                IElement el;
                if (!(selectionElement instanceof IAdaptable) || (el = (IElement)(selectedAdapter = (IAdaptable)selectionElement).getAdapter(IElement.class)) == null) continue;
                selectedElements.add(el);
            }
            this.update(selectedElements);
        }
    }

    private void update(ArrayList<IElement> selectedElements) {
        this.toolbarManager.removeAll();
        this.addEditCatalogAction();
        for (Catalog cat : this.catalogProvider.getCatalogs()) {
            for (Script script : cat.getScripts()) {
                if (!script.shownInToolbar() || !script.isRunnableOn(selectedElements)) continue;
                RunScriptAction action = new RunScriptAction(script, this.scriptRunner);
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.getMode();
                this.toolbarManager.add((IContributionItem)item);
            }
        }
        this.modelioCoolbarManager.update(true);
        this.toolbarManager.update(true);
    }

    private void addEditCatalogAction() {
        2 action = new /* Unavailable Anonymous Inner Class!! */;
        URL imageUrl = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/scriptcatalog_16.png"), null);
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)imageUrl));
        action.setToolTipText(Messages.getString((String)"Toolbar.EditCatalogTooltip"));
        this.toolbarManager.add((IAction)action);
        this.toolbarManager.add((IContributionItem)new Separator());
    }

    static /* synthetic */ void access$0(ToolbarAdvisor toolbarAdvisor) {
        toolbarAdvisor.refresh();
    }
}

