/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.utils;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.script.engine.ISelectionGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.services.IServiceLocator;

public class SelectionGetter
implements ISelectionGetter {
    private static Collection<IElement> emptySelection = Collections.unmodifiableCollection(new ArrayList(0));
    private ISelectionService selectionService;

    public static Collection<IElement> getEmptySelection() {
        return emptySelection;
    }

    public SelectionGetter(IServiceLocator serviceLocator) {
        this.selectionService = (ISelectionService)serviceLocator.getService(ISelectionService.class);
    }

    public SelectionGetter(ISelectionService selectionService2) {
        this.selectionService = selectionService2;
        if (this.selectionService == null) {
            throw new IllegalArgumentException("selectionService must not be null.");
        }
    }

    public Collection<IElement> getSelectedElements() {
        ISelection newSelection = this.selectionService.getSelection();
        if (newSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)newSelection;
            ArrayList<IElement> selectedElements = new ArrayList<IElement>(structuredSelection.size());
            for (Object selectionElement : structuredSelection.toList()) {
                IAdaptable selectedAdapter;
                IElement el;
                if (!(selectionElement instanceof IAdaptable) || (el = (IElement)(selectedAdapter = (IAdaptable)selectionElement).getAdapter(IElement.class)) == null) continue;
                selectedElements.add(el);
            }
            return selectedElements;
        }
        return emptySelection;
    }

    public ISelection getSelection() {
        return this.selectionService.getSelection();
    }
}

