/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.views;

import com.modeliosoft.modelio.script.engine.IInputView;
import com.modeliosoft.modelio.script.i18n.Messages;
import com.modeliosoft.modelio.script.views.InputView;
import com.modeliosoft.modelio.script.views.TextViewerDragDropManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.State;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

class InputView
extends SourceViewer
implements IInputView {
    private static final String MENU_ID = "com.modeliosoft.modelio.script.InputViewID";
    private static final String REDO_COMMAND_ID = "com.modeliosoft.modelio.script.RedoCommandID";
    private static final String SELECT_ALL_COMMAND_ID = "com.modeliosoft.modelio.script.SelectAllCommandID";
    private static final String SHIFT_LEFT_COMMAND_ID = "com.modeliosoft.modelio.script.ShiftLeftCommandID";
    private static final String SHIFT_RIGHT_COMMAND_ID = "com.modeliosoft.modelio.script.ShiftRightCommandID";
    private static final String UNDO_COMMAND_ID = "com.modeliosoft.modelio.script.UndoCommandID";
    private Document document;
    private Map<String, IAction> globalActions = new HashMap();
    private IViewPart viewPart;
    private List<String> selectionDependentActions = new ArrayList();

    public InputView(Composite parent, int styles, IViewPart viewPart) {
        super(parent, (IVerticalRuler)new CompositeRuler(), styles);
        this.viewPart = viewPart;
        InputViewSourceViewerConfiguration configuration = new InputViewSourceViewerConfiguration(null);
        this.configure((SourceViewerConfiguration)configuration);
        this.document = new Document();
        this.setDocument((IDocument)this.document);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        this.getTextWidget().setFont(font);
        CompositeRuler verticalRuler = (CompositeRuler)this.getVerticalRuler();
        LineNumberRulerColumn column = new LineNumberRulerColumn();
        verticalRuler.addDecorator(0, (IVerticalRulerColumn)column);
        this.initializeActions();
        this.initializeKeyBindingHandlers();
        new TextViewerDragDropManager(viewPart, (TextViewer)this);
    }

    public void append(String content) {
        try {
            int offset = this.getDocument().getLength() - 1;
            int length = 0;
            if (offset < 0) {
                offset = 0;
            }
            this.getDocument().replace(offset, length, content);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public String getText() {
        return this.getDocument().get();
    }

    public String popInput() {
        try {
            Point selection = this.getSelectedRange();
            if (selection.y == 0) {
                selection.x = 0;
                selection.y = this.getDocument().getLength();
                String ret = this.getDocument().get(selection.x, selection.y);
                if (!this.isDebugMode()) {
                    this.getDocument().replace(0, selection.y, "");
                }
                return ret;
            }
            String ret = this.getDocument().get(selection.x, selection.y);
            if (!this.isDebugMode()) {
                this.getDocument().replace(selection.x, selection.y, "");
            }
            return ret;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected void fillContextMenu(IMenuManager menu) {
        for (IAction act : this.globalActions.values()) {
            if (!(act instanceof IUpdate)) continue;
            ((IUpdate)act).update();
        }
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this.globalActions.get(ActionFactory.UNDO.getId()));
        menu.appendToGroup("group.undo", (IAction)this.globalActions.get(ActionFactory.REDO.getId()));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this.globalActions.get(ActionFactory.CUT.getId()));
        menu.appendToGroup("group.edit", (IAction)this.globalActions.get(ActionFactory.COPY.getId()));
        menu.appendToGroup("group.edit", (IAction)this.globalActions.get(ActionFactory.PASTE.getId()));
        menu.appendToGroup("group.edit", (IAction)this.globalActions.get(SELECT_ALL_COMMAND_ID));
        menu.add((IContributionItem)new Separator());
        menu.appendToGroup("group.edit", (IAction)this.globalActions.get(SHIFT_RIGHT_COMMAND_ID));
        menu.appendToGroup("group.edit", (IAction)this.globalActions.get(SHIFT_LEFT_COMMAND_ID));
        menu.add((IContributionItem)new Separator("group.execute"));
    }

    private void initializeActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        TextViewerAction action = new TextViewerAction((ISourceViewer)this, 1);
        action.setText(Messages.getString((String)"Menus.Edit.Undo"));
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        action.setAccelerator(262234);
        this.globalActions.put(ActionFactory.UNDO.getId(), action);
        action = new TextViewerAction((ISourceViewer)this, 2);
        action.setText(Messages.getString((String)"Menus.Edit.Redo"));
        action.setAccelerator(262233);
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
        this.globalActions.put(ActionFactory.REDO.getId(), action);
        action = new TextViewerAction((ISourceViewer)this, 3);
        action.setText(Messages.getString((String)"Menus.Edit.Cut"));
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.globalActions.put(ActionFactory.CUT.getId(), action);
        action = new TextViewerAction((ISourceViewer)this, 4);
        action.setText(Messages.getString((String)"Menus.Edit.Copy"));
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.globalActions.put(ActionFactory.COPY.getId(), action);
        action = new TextViewerAction((ISourceViewer)this, 5);
        action.setText(Messages.getString((String)"Menus.Edit.Paste"));
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.globalActions.put(ActionFactory.PASTE.getId(), action);
        action = new TextViewerAction((ISourceViewer)this, 7);
        action.setText(Messages.getString((String)"Menus.Edit.SelectAll"));
        this.globalActions.put(ActionFactory.SELECT_ALL.getId(), action);
        this.globalActions.put(SELECT_ALL_COMMAND_ID, action);
        action = new TextViewerAction((ISourceViewer)this, 9);
        action.setText(Messages.getString((String)"Menus.Edit.ShiftLeft"));
        action.setAccelerator(SWT.MOD2 | 9);
        this.globalActions.put(SHIFT_LEFT_COMMAND_ID, action);
        action = new TextViewerAction((ISourceViewer)this, 8);
        action.setText(Messages.getString((String)"Menus.Edit.ShiftRight"));
        action.setAccelerator(9);
        this.globalActions.put(SHIFT_RIGHT_COMMAND_ID, action);
        this.selectionDependentActions.add(ActionFactory.CUT.getId());
        this.selectionDependentActions.add(ActionFactory.COPY.getId());
        this.selectionDependentActions.add(ActionFactory.PASTE.getId());
        this.selectionDependentActions.add(SHIFT_LEFT_COMMAND_ID);
        this.selectionDependentActions.add(SHIFT_RIGHT_COMMAND_ID);
        this.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addTextListener((ITextListener)new /* Unavailable Anonymous Inner Class!! */);
        this.initializeContextualMenu();
    }

    private void initializeContextualMenu() {
        MenuManager manager = new MenuManager(null, MENU_ID);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        StyledText text = this.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
        this.viewPart.getViewSite().registerContextMenu(MENU_ID, manager, (ISelectionProvider)this);
    }

    private void initializeKeyBindingHandlers() {
        IHandlerService service = (IHandlerService)this.viewPart.getSite().getService(IHandlerService.class);
        service.activateHandler(UNDO_COMMAND_ID, (IHandler)new UndoCommandHandler(this, null));
        service.activateHandler(REDO_COMMAND_ID, (IHandler)new RedoCommandHandler(this, null));
        service.activateHandler(SHIFT_LEFT_COMMAND_ID, (IHandler)new ActionHandler((IAction)this.globalActions.get(SHIFT_LEFT_COMMAND_ID)));
        service.activateHandler(SHIFT_RIGHT_COMMAND_ID, (IHandler)new ActionHandler((IAction)this.globalActions.get(SHIFT_RIGHT_COMMAND_ID)));
        service.activateHandler(SELECT_ALL_COMMAND_ID, (IHandler)new ActionHandler((IAction)this.globalActions.get(SELECT_ALL_COMMAND_ID)));
    }

    private boolean isDebugMode() {
        ICommandService service = (ICommandService)this.viewPart.getSite().getService(ICommandService.class);
        Command command = service.getCommand("com.modeliosoft.modelio.script.DebugModeCommandID");
        State state = command.getState("com.modeliosoft.modelio.script.DebugModeToggleID");
        return (Boolean)state.getValue();
    }

    private void updateAction(String actionId) {
        IAction action = (IAction)this.globalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private void updateSelectionDependentActions() {
        for (String id : this.selectionDependentActions) {
            this.updateAction(id);
        }
    }

    private void updateUndoAction() {
        this.updateAction(ActionFactory.UNDO.getId());
    }

    static /* synthetic */ void access$0(InputView inputView) {
        inputView.updateSelectionDependentActions();
    }

    static /* synthetic */ void access$1(InputView inputView) {
        inputView.updateUndoAction();
    }
}

