/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.views;

import com.modeliosoft.modelio.script.views.OutputView;
import com.modeliosoft.modelio.script.views.TextAppender;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class OutputWriter
extends Writer {
    protected TextAppender appender;
    private Runnable onFlush;
    private boolean isToFlush = false;

    public OutputWriter(StyledText outputView) {
        TextStyle style = new TextStyle(null, Display.getDefault().getSystemColor(5), null);
        this.appender = new TextAppender(outputView, style);
    }

    public OutputWriter(StyledText outputView, TextStyle style) {
        this.appender = new TextAppender(outputView, style);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.appender = null;
        this.onFlush = null;
    }

    @Override
    public void flush() throws IOException {
        if (this.isToFlush && this.onFlush != null) {
            this.onFlush.run();
            this.isToFlush = false;
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        String string = String.valueOf(cbuf, off, len);
        this.appender.execute(string);
        this.isToFlush = true;
    }

    public OutputWriter(OutputView outputView, TextStyle textStyle, Runnable onFlush) {
        this((StyledText)outputView, textStyle);
        this.onFlush = onFlush;
    }
}

