/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.script.views;

import com.modeliosoft.modelio.script.i18n.Messages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class StyledTextMenuProvider {
    StyledTextMenuProvider(StyledText text) {
        this.createMenu(text);
    }

    private void createMenu(StyledText text) {
        Menu popupMenu = new Menu((Control)text);
        text.setMenu(popupMenu);
        popupMenu.addListener(22, (Listener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isClipBoard(StyledText text) {
        Clipboard c = new Clipboard(text.getDisplay());
        String s = (String)c.getContents((Transfer)TextTransfer.getInstance(), 1);
        c.dispose();
        return s != null && !s.isEmpty();
    }

    protected void populateMenu(StyledText text, Menu popupMenu) {
        boolean isSelection = !text.getSelectionText().isEmpty();
        boolean isClipBoard = this.isClipBoard(text);
        boolean enabled = text.isEnabled() && text.getEditable();
        MenuItem cutItem = new MenuItem(popupMenu, 8);
        cutItem.setText(Messages.getString((String)"Menus.Edit.Cut"));
        cutItem.setImage(null);
        cutItem.setAccelerator(262232);
        cutItem.setEnabled(isSelection && enabled);
        cutItem.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        MenuItem copyItem = new MenuItem(popupMenu, 8);
        copyItem.setText(Messages.getString((String)"Menus.Edit.Copy"));
        copyItem.setImage(null);
        copyItem.setAccelerator(262211);
        copyItem.setEnabled(isSelection);
        copyItem.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        MenuItem pasteItem = new MenuItem(popupMenu, 8);
        pasteItem.setText(Messages.getString((String)"Menus.Edit.Paste"));
        pasteItem.setImage(null);
        pasteItem.setAccelerator(262230);
        pasteItem.setEnabled(isClipBoard && enabled);
        pasteItem.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        MenuItem deleteItem = new MenuItem(popupMenu, 8);
        deleteItem.setText(Messages.getString((String)"Menus.Edit.Delete"));
        deleteItem.setImage(null);
        deleteItem.setEnabled(enabled);
        deleteItem.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        new MenuItem(popupMenu, 2);
        MenuItem selectAllItem = new MenuItem(popupMenu, 8);
        selectAllItem.setText(Messages.getString((String)"Menus.Edit.SelectAll"));
        selectAllItem.setImage(null);
        selectAllItem.setAccelerator(262209);
        selectAllItem.setEnabled(true);
        selectAllItem.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
    }
}

