/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.extern.helper;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocumentType;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import java.io.File;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;

public class ExternDocLabelProvider {
    private ExternDocLabelProvider() {
        throw new UnsupportedOperationException();
    }

    public static Image getIcon(IExternDocument doc) {
        DocumentFormat format = O.getDefault().getDocumentFormatsRegistry().getDocumentFormatForMime(doc.getMimeType());
        return format.getIcon();
    }

    public static ImageDescriptor getIcon(File aFile) {
        ImageData data;
        Program program;
        String fname = aFile.getName();
        int idx = fname.lastIndexOf(46);
        if (idx != -1 && (program = Program.findProgram((String)fname.substring(idx))) != null && (data = program.getImageData()) != null) {
            return ImageDescriptor.createFromImageData((ImageData)data);
        }
        return null;
    }

    public static String getLabel(IExternDocument document) {
        String name = document.getName();
        IExternDocumentType type = document.getType();
        if (type != null) {
            String label;
            if (!name.isEmpty()) {
                name = String.valueOf(name) + " ";
            }
            if (!(label = type.getLabel()).isEmpty()) {
                return String.valueOf(name) + "[" + label + "]";
            }
            return String.valueOf(name) + "[" + type.getName() + "]";
        }
        return name;
    }
}

