/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.extern.model;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.exml.ExmlFileHelper;
import com.modeliosoft.modelio.core.model.CompositionServices;
import com.modeliosoft.modelio.core.model.change.IElementDeletedEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeHandler;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.edition.extern.model.RichNoteChangeHandler;
import com.modeliosoft.modelio.edition.extern.plugin.ExternEditors;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class RichNoteChangeHandler
implements IModelChangeHandler,
IModelChangeListener {
    private static final boolean TRACE = false;
    private static final String RECYCLED_DIRNAME = ".recycled";
    private MultiStatus status;
    private IModelChangeEvent lastHandledEvent = null;
    private Path richNoteDir;
    private Path recycledDir;
    private Path projectSpacePath;

    public RichNoteChangeHandler(IModelingSession session) {
        FileSystem fs = FileSystems.getDefault();
        this.projectSpacePath = fs.getPath(session.getProjectSpacePath().getAbsolutePath(), new String[0]);
        this.richNoteDir = fs.getPath(this.projectSpacePath.toString(), ".projectdata", "model", "ExternDocument");
        this.recycledDir = fs.getPath(this.projectSpacePath.toString(), RECYCLED_DIRNAME, "model", "ExternDocument");
        try {
            Files.createDirectories(this.recycledDir, new FileAttribute[0]);
            this.sync(session);
        }
        catch (IOException e) {
            this.handleError(e);
            this.reportErrors();
        }
    }

    public void handleModelChange(IModelingSession session, IModelChangeEvent event) {
        this.lastHandledEvent = event;
        this.status = null;
        IElementDeletedEvent[] iElementDeletedEventArray = event.getDeleteEvents();
        int n = iElementDeletedEventArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementDeletedEvent del = iElementDeletedEventArray[n2];
            if (del.getDeletedElement() instanceof IExternDocument) {
                try {
                    this.moveNoteFile(del.getDeletedElement(), this.richNoteDir, this.recycledDir);
                }
                catch (IOException e) {
                    this.handleError(e);
                }
            }
            ++n2;
        }
        for (IElement el : event.getCreationEvents()) {
            for (IExternDocument doc : this.getDocuments(el)) {
                String docPath = doc.getPath();
                if (docPath.isEmpty()) continue;
                try {
                    Path f;
                    if (docPath.contains(doc.getIdentifier())) {
                        Path r;
                        f = this.projectSpacePath.resolve(doc.getPath());
                        if (Files.isRegularFile(f, new LinkOption[0]) || !Files.isRegularFile(r = this.recycledDir.resolve(f.getFileName()), new LinkOption[0])) continue;
                        Files.move(r, f, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    f = this.projectSpacePath.resolve(doc.getPath());
                    if (!Files.isRegularFile(f, new LinkOption[0])) {
                        f = this.recycledDir.resolve(f.getFileName());
                    }
                    if (Files.isRegularFile(f, new LinkOption[0])) {
                        String copyPath = ExmlFileHelper.buildDocumentPath((IExternDocument)doc, (String)this.getExtension(f));
                        doc.setPath(copyPath);
                        Path newFile = this.projectSpacePath.resolve(copyPath);
                        Files.copy(f, newFile, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    ExternEditors.LOG.info("copy/pasted '" + doc.getName() + "' {" + doc.getIdentifier() + "} rich note has no file.");
                }
                catch (IOException e) {
                    this.handleError(e);
                }
            }
        }
        this.reportErrors();
    }

    private void reportErrors() {
        if (this.status != null && !this.status.isOK()) {
            StatusAdapter a = new StatusAdapter((IStatus)this.status);
            a.setProperty(IStatusAdapterConstants.HINT_PROPERTY, (Object)ExternEditors.I18N.getString("RichNoteChangeHandler.failures.hint"));
            a.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)ExternEditors.I18N.getString("RichNoteChangeHandler.failures.title"));
            a.setProperty(IStatusAdapterConstants.EXPLANATION_PROPERTY, (Object)ExternEditors.I18N.getString("RichNoteChangeHandler.failures.explanation"));
            StatusManager.getManager().handle(a, 2);
        }
    }

    private void handleError(IOException e) {
        ExternEditors.LOG.error((Throwable)e);
        if (this.status == null) {
            this.status = new MultiStatus("org.modelio.edition.extern", 1, ExternEditors.I18N.getString("RichNoteChangeHandler.failures"), null);
        }
        Status status2 = new Status(4, "org.modelio.edition.extern", 1, this.getLocalizedMessage(e), null);
        this.status.add((IStatus)status2);
    }

    private String getLocalizedMessage(IOException e) {
        if (e instanceof FileSystemException) {
            FileSystemException fe = (FileSystemException)e;
            String message = ExternEditors.I18N.getMessage("exception." + e.getClass().getSimpleName(), new String[]{fe.getFile(), fe.getOtherFile()});
            if (fe.getReason() != null && !fe.getReason().isEmpty()) {
                return String.valueOf(message) + "\n" + fe.getReason();
            }
            return message;
        }
        return e.getLocalizedMessage();
    }

    private void moveNoteFile(IElement deletedElement, Path richNoteDir2, Path recycledDir2) throws IOException {
        String id = deletedElement.getIdentifier();
        1 filter = new /* Unavailable Anonymous Inner Class!! */;
        Throwable throwable = null;
        Object var7_8 = null;
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(richNoteDir2, (DirectoryStream.Filter<? super Path>)filter);){
            for (Path found : dirStream) {
                Path recycledPath = recycledDir2.resolve(found.getFileName());
                Files.move(found, recycledPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void sync(IModelingSession session) {
        DirectoryStream<Path> dirStream;
        Object var4_8;
        this.status = null;
        2 filter = new /* Unavailable Anonymous Inner Class!! */;
        if (Files.isDirectory(this.richNoteDir, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                var4_8 = null;
                try {
                    dirStream = Files.newDirectoryStream(this.richNoteDir, (DirectoryStream.Filter<? super Path>)filter);
                    try {
                        for (Path found : dirStream) {
                            if (session.getModel().findByRef(this.getRef(found)) != null) continue;
                            try {
                                Files.delete(found);
                            }
                            catch (IOException e) {
                                this.handleError(e);
                            }
                        }
                    }
                    finally {
                        if (dirStream != null) {
                            dirStream.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        }
        try {
            Throwable e = null;
            var4_8 = null;
            try {
                dirStream = Files.newDirectoryStream(this.recycledDir, (DirectoryStream.Filter<? super Path>)filter);
                try {
                    for (Path found : dirStream) {
                        if (session.getModel().findByRef(this.getRef(found)) == null) {
                            try {
                                Files.delete(found);
                            }
                            catch (IOException e2) {
                                this.handleError(e2);
                            }
                            continue;
                        }
                        try {
                            Path restorePath = this.richNoteDir.resolve(found.getFileName());
                            Files.move(found, restorePath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e3) {
                            this.handleError(e3);
                        }
                    }
                }
                finally {
                    if (dirStream != null) {
                        dirStream.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            this.handleError(e);
        }
        this.reportErrors();
    }

    private ObRef getRef(Path aFilePath) {
        String fileName = aFilePath.getFileName().toString();
        String id = fileName.substring(0, fileName.lastIndexOf(46));
        return new ObRef("ExternDocument", id);
    }

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        if (event != this.lastHandledEvent) {
            this.handleModelChange(session, event);
        }
    }

    private List<IExternDocument> getDocuments(IElement el) {
        ArrayList<IExternDocument> ret = new ArrayList<IExternDocument>();
        if (el instanceof IExternDocument) {
            ret.add((IExternDocument)el);
        }
        List l = CompositionServices.getAllCompositionChildren((IElement)el);
        for (IElement child : l) {
            if (!(child instanceof IExternDocument)) continue;
            ret.add((IExternDocument)child);
        }
        return ret;
    }

    private String getExtension(Path f) {
        String spath = f.toString();
        int idx = spath.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return spath.substring(idx + 1);
    }
}

