/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.extern.plugin;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IActivationListener;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import com.modeliosoft.modelio.edition.extern.plugin.ExternEditors;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

final class ExternEditorActivationListener
implements IActivationListener {
    private File projectPath;

    public ExternEditorActivationListener(File projectPath) {
        this.projectPath = projectPath;
    }

    public boolean activateElement(IElement target) {
        DocumentFormat format = null;
        if (target instanceof IArtifact) {
            String targetFileName = ((IArtifact)target).getFileName();
            File targetFile = new File(targetFileName);
            if (!targetFile.exists()) {
                targetFile = new File(this.projectPath, targetFileName);
            }
            if (targetFile.exists()) {
                format = O.getDefault().getDocumentFormatsRegistry().getFileFormat(targetFile);
            }
        } else if (target instanceof IExternDocument) {
            format = O.getDefault().getDocumentFormatsRegistry().getFormat((IExternDocument)target);
        }
        if (format != null) {
            if (format.isUsable()) {
                return format.getEditorProvider().openEditor(target);
            }
            this.reportFormatNotUsable(format);
        }
        return false;
    }

    private void reportFormatNotUsable(DocumentFormat format) {
        String message = ExternEditors.I18N.getMessage("DocumentFormatNotEditable", new String[]{format.getLabel(), format.getMimeType()});
        Status status = new Status(1, "org.modelio.edition.extern", message);
        StatusManager.getManager().handle((IStatus)status, 2);
    }
}

