/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.extern.plugin;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

class ExternEditorRegistry {
    private Map<IElement, IEditorPart> editors = new HashMap();

    ExternEditorRegistry() {
    }

    public void closeAll() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            ArrayList copy = new ArrayList(this.editors.values());
            for (IEditorPart editor : copy) {
                window.getActivePage().closeEditor(editor, false);
            }
            this.editors.clear();
        }
    }

    public void remove(IElement editedEl) {
        this.editors.remove(editedEl);
    }

    public void put(IElement editedEl, IEditorPart editor) throws IllegalArgumentException {
        if (this.editors.containsKey(editedEl)) {
            throw new IllegalArgumentException(editedEl + " already registered");
        }
        this.editors.put(editedEl, editor);
    }

    public IEditorPart get(IElement toEdit) {
        return (IEditorPart)this.editors.get(toEdit);
    }
}

