/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.extern.plugin;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IActivationListener;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import com.modeliosoft.modelio.core.documents.IDocumentFormatRegistry;
import com.modeliosoft.modelio.core.log.PluginLogger;
import com.modeliosoft.modelio.core.model.change.IModelChangeHandler;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.edition.extern.model.RichNoteChangeHandler;
import com.modeliosoft.modelio.edition.extern.plugin.ExternEditorActivationListener;
import com.modeliosoft.modelio.edition.extern.plugin.ExternEditorRegistry;
import com.modeliosoft.modelio.ui.i18n.BundledMessages;
import java.util.ResourceBundle;

public class ExternEditors
implements ISessionListener {
    private static ExternEditors _instance = null;
    private IModelingSession modelingSession;
    private ExternEditorRegistry editorsRegistry = null;
    public static final String PLUGIN_ID = "org.modelio.edition.extern";
    private IActivationListener activationListener;
    public static final PluginLogger LOG = new PluginLogger("org.modelio.edition.extern");
    public static final BundledMessages I18N = new BundledMessages("org.modelio.edition.extern", ResourceBundle.getBundle("edition_extern"));
    private RichNoteChangeHandler changeHandler;

    public static ExternEditors getInstance() {
        if (_instance == null) {
            _instance = new ExternEditors();
        }
        return _instance;
    }

    public IModelingSession getModelingSession() {
        return this.modelingSession;
    }

    public void sessionClosed(IModelingSession session) {
        if (this.editorsRegistry != null) {
            this.editorsRegistry.closeAll();
            this.editorsRegistry = null;
        }
        if (this.changeHandler != null) {
            this.modelingSession.getModel().removeModelListener((IModelChangeListener)this.changeHandler);
            this.modelingSession.getModel().removeModelHandler((IModelChangeHandler)this.changeHandler);
            this.changeHandler = null;
        }
        if (this.activationListener != null) {
            O.getDefault().getActivationService().removeActivationListener(this.activationListener);
            this.activationListener = null;
        }
        this.modelingSession = null;
    }

    public void sessionOpened(IModelingSession session) {
        this.modelingSession = session;
        this.editorsRegistry = new ExternEditorRegistry();
        this.activationListener = new ExternEditorActivationListener(session.getProjectSpacePath());
        this.changeHandler = new RichNoteChangeHandler(session);
        session.getModel().addModelHandler((IModelChangeHandler)this.changeHandler);
        session.getModel().addModelListener((IModelChangeListener)this.changeHandler);
        O.getDefault().getActivationService().addActivationListener(this.activationListener);
    }

    private ExternEditors() {
    }

    public ExternEditorRegistry getRegistry() {
        return this.editorsRegistry;
    }

    @Deprecated
    public IDocumentFormatRegistry getProviderRegistry() {
        return O.getDefault().getDocumentFormatsRegistry();
    }
}

