/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.commands;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.exceptions.ObElementDeletedException;
import com.modeliosoft.modelio.api.utils.exceptions.ObElementNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.internal.core.audit.ICoreAudit;
import com.modeliosoft.modelio.explorer.plugin.Explorer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class AuditElementAction
extends Action
implements KeyListener {
    public static final String ACTION_ID = "com.modeliosoft.modelio.explorer.AuditElementCommandID";

    public AuditElementAction() {
    }

    public AuditElementAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public AuditElementAction(String text, int style) {
        super(text, style);
    }

    public AuditElementAction(String text) {
        super(text);
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void runWithEvent(Event event) {
        List selectedElements = this.getSelectedElements();
        IModelingSession session = Explorer.getInstance().getModelingSession();
        if (session != null) {
            ICoreAudit audit = session.getAudit();
            for (IElement element : selectedElements) {
                try {
                    audit.auditElement(element);
                }
                catch (ObElementDeletedException obElementDeletedException) {
                }
                catch (ObElementNotFoundException obElementNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private List<IElement> getSelectedElements() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }
}

