/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.commands;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IClassAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.core.model.expert.ICreationExpert;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.core.workbench.PasteElementObject;
import com.modeliosoft.modelio.core.workbench.PasteElementTransfer;
import com.modeliosoft.modelio.core.workbench.TransferItem;
import com.modeliosoft.modelio.explorer.plugin.Explorer;
import com.modeliosoft.modelio.explorer.util.Messages;
import com.modeliosoft.modelio.explorer.views.UmlNavigatorView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class PasteElementAction
extends Action {
    private Clipboard clipboard;
    public static final String ACTION_ID = "com.modeliosoft.modelio.explorer.PasteElementCommandID";
    private UmlNavigatorView umlView = null;

    public PasteElementAction() {
        this.setActionDefinitionId(ACTION_ID);
    }

    public PasteElementAction(String text, ImageDescriptor image, Clipboard clipboard, UmlNavigatorView view) {
        super(text, image);
        this.clipboard = clipboard;
        this.umlView = view;
        this.setActionDefinitionId(ACTION_ID);
    }

    public PasteElementAction(String text, int style) {
        super(text, style);
        this.setActionDefinitionId(ACTION_ID);
    }

    public PasteElementAction(String text) {
        super(text);
        this.setActionDefinitionId(ACTION_ID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runWithEvent(Event event) {
        if (event.widget instanceof Tree || event.widget instanceof MenuItem) {
            ITransaction transaction;
            Object transactionManager;
            IModelingSession modelingSession;
            List selectedElements = this.getSelectedElements();
            if (selectedElements.size() != 1) return;
            IElement targetElement = (IElement)selectedElements.get(0);
            PasteElementObject pastedObject = (PasteElementObject)this.clipboard.getContents((Transfer)PasteElementTransfer.getInstance());
            if (pastedObject == null) {
                return;
            }
            List items = pastedObject.getTransferedItems();
            List pastedStereotypeItems = this.getStereotypesItemsToCopy(items);
            List pastedElements = this.getElementsToCopy(items);
            for (IElement element : pastedElements) {
                IAssociation targetAssociation;
                if (!this.canBeParentOf(targetElement, element)) {
                    return;
                }
                if (element instanceof IAssociation || element instanceof ILink) {
                    return;
                }
                if (element instanceof IParameter) {
                    IOperation targetOperation;
                    IParameter parameter = (IParameter)element;
                    if (!(targetElement instanceof IOperation) || parameter.getReturned() == null || (targetOperation = (IOperation)targetElement).getReturn() == null) continue;
                    return;
                }
                if (!(element instanceof IClassAssociation) || !(targetElement instanceof IAssociation) || (targetAssociation = (IAssociation)targetElement).getLinkToClass() == null) continue;
                return;
            }
            if (pastedObject.getPasteType() == PasteElementObject.PasteType.COPY) {
                modelingSession = Explorer.getInstance().getModelingSession();
                transactionManager = modelingSession.getTransactionManager();
                transaction = transactionManager.createTransaction("Copy");
                try {
                    try {
                        ArrayList copyResult = new ArrayList();
                        if (pastedElements.size() > 0) {
                            copyResult.addAll(ModelServices.copyTo((Collection)new ObList((Collection)pastedElements), (IElement)targetElement));
                        }
                        if (targetElement instanceof IModelElement) {
                            IModelElement selectedModelElement = (IModelElement)targetElement;
                            for (TransferItem item : pastedStereotypeItems) {
                                IStereotype stereotype = (IStereotype)item.getTransferedElement();
                                if (selectedModelElement.isStereotyped(stereotype.getName())) continue;
                                selectedModelElement.addExtension(stereotype);
                            }
                        }
                        transactionManager.commit(transaction);
                        transaction = null;
                        if (copyResult.size() < 1) return;
                        IElement copiedElement = (IElement)copyResult.get(0);
                        if (copiedElement instanceof INote) {
                            O.getDefault().getNavigateService().fireNavigate(copiedElement);
                            return;
                        } else {
                            this.umlView.setExpandedState(targetElement, true);
                        }
                        return;
                    }
                    catch (InvalidTransactionException e) {
                        transaction = null;
                        if (transaction == null) return;
                        transactionManager.rollback(transaction);
                        return;
                    }
                    catch (Exception e) {
                        this.reportException(e);
                        if (transaction == null) return;
                        transactionManager.rollback(transaction);
                        return;
                    }
                }
                finally {
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                    }
                }
            }
            if (pastedObject.getPasteType() != PasteElementObject.PasteType.CUT) return;
            for (IElement element : pastedElements) {
                if (!element.equals((Object)targetElement) && !this.isParentOf(element, targetElement)) continue;
                return;
            }
            modelingSession = Explorer.getInstance().getModelingSession();
            transactionManager = modelingSession.getTransactionManager();
            transaction = transactionManager.createTransaction("Cut");
            try {
                try {
                    if (!pastedElements.isEmpty()) {
                        ModelServices.moveTo((Collection)new ObList((Collection)pastedElements), (IElement)targetElement);
                    }
                    if (targetElement instanceof IModelElement) {
                        IModelElement selectedModelElement = (IModelElement)targetElement;
                        for (TransferItem item : pastedStereotypeItems) {
                            IStereotype stereotype = (IStereotype)item.getTransferedElement();
                            IModelElement oldParent = (IModelElement)item.getOldParent();
                            oldParent.removeExtension(stereotype);
                            if (selectedModelElement.isStereotyped(stereotype.getName())) continue;
                            selectedModelElement.addExtension(stereotype);
                        }
                    }
                    transactionManager.commit(transaction);
                    transaction = null;
                    if (!pastedElements.isEmpty()) {
                        IElement movedElement = (IElement)pastedElements.get(0);
                        if (movedElement instanceof INote) {
                            O.getDefault().getNavigateService().fireNavigate(movedElement);
                        } else {
                            this.umlView.setExpandedState(targetElement, true);
                        }
                    }
                    pastedObject.setPasteType(PasteElementObject.PasteType.COPY);
                    this.clipboard.setContents(new Object[]{pastedObject}, new Transfer[]{PasteElementTransfer.getInstance()});
                    return;
                }
                catch (InvalidTransactionException e) {
                    transaction = null;
                    if (transaction == null) return;
                    transactionManager.rollback(transaction);
                    return;
                }
                catch (Exception e) {
                    this.reportException(e);
                    if (transaction == null) return;
                    transactionManager.rollback(transaction);
                    return;
                }
            }
            finally {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        if (!(event.widget instanceof Text)) return;
        Text text = (Text)event.widget;
        text.paste();
    }

    void reportException(Exception e) {
        String title = Messages.getMessage((String)"CannotPasteClipboard", (String[])new String[0]);
        MessageDialog.openError(null, (String)title, (String)e.getLocalizedMessage());
        if (!(e instanceof InvalidModelManipulationException)) {
            e.printStackTrace();
        }
    }

    private List<IElement> getElementsToCopy(List<TransferItem> items) {
        ArrayList<IElement> elementsToCopy = new ArrayList<IElement>();
        for (TransferItem item : items) {
            IElement transferedElement = item.getTransferedElement();
            if (transferedElement instanceof IStereotype) continue;
            elementsToCopy.add(transferedElement);
        }
        return elementsToCopy;
    }

    private List<IElement> getSelectedElements() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }

    private List<TransferItem> getStereotypesItemsToCopy(List<TransferItem> items) {
        ArrayList<TransferItem> stereotypeItemsToCopy = new ArrayList<TransferItem>();
        for (TransferItem item : items) {
            if (!(item.getTransferedElement() instanceof IStereotype)) continue;
            stereotypeItemsToCopy.add(item);
        }
        return stereotypeItemsToCopy;
    }

    private boolean isParentOf(IElement parentCandidate, IElement element) {
        IElement parent = element.getCompositionOwner();
        if (parent == null) {
            return false;
        }
        if (parentCandidate.equals((Object)parent)) {
            return true;
        }
        return this.isParentOf(parentCandidate, parent);
    }

    private boolean canBeParentOf(IElement parent, IElement child) {
        ICreationExpert expert;
        if (parent instanceof IModelElement) {
            IModelElement p = (IModelElement)parent;
            for (IStereotype s : p.getExtension()) {
                ICreationExpert expert2 = CreationExpertRegistry.getExpert((IStereotype)s);
                if (expert2 == null || expert2.canOwn(parent, child, null) || expert2.canLinkFrom(parent, null)) continue;
                return false;
            }
        }
        if ((expert = CreationExpertRegistry.getExpert(parent.getClass())).canOwn(parent, child, null)) {
            return true;
        }
        return expert.canLinkFrom(parent, null);
    }
}

