/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.commands;

import com.modeliosoft.modelio.explorer.views.UmlNavigatorView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RenameElementAction
extends Action {
    public static final String ACTION_ID = "com.modeliosoft.modelio.explorer.RenameElementCommandID";

    public RenameElementAction() {
    }

    public RenameElementAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public RenameElementAction(String text, int style) {
        super(text, style);
    }

    public RenameElementAction(String text) {
        super(text);
    }

    public void runWithEvent(Event event) {
        List selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 1) {
            IAdaptable selectedObject = (IAdaptable)selectedElements.get(0);
            UmlNavigatorView view = this.getUmlNavigatorView();
            if (view != null) {
                view.getCommonViewer().editElement((Object)selectedObject, 0);
            }
        }
    }

    private List<IAdaptable> getSelectedElements() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        ArrayList<IAdaptable> selectedElements = new ArrayList<IAdaptable>();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add(adapter);
            }
        }
        return selectedElements;
    }

    private UmlNavigatorView getUmlNavigatorView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof UmlNavigatorView) {
            return (UmlNavigatorView)activePart;
        }
        return null;
    }
}

