/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.dnd;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IClassAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.core.model.expert.ICreationExpert;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.explorer.plugin.Explorer;
import com.modeliosoft.modelio.explorer.util.Messages;
import com.modeliosoft.modelio.explorer.views.UmlNavigatorView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class UmlNavigatorDropAssistant
extends CommonDropAdapterAssistant {
    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent event, Object target) {
        block16: {
            Object data = event.data;
            if (data == null || target == null) {
                return Status.CANCEL_STATUS;
            }
            List selectedElements = null;
            TransferData currentTransfer = dropAdapter.getCurrentTransfer();
            if (LocalSelectionTransfer.getTransfer().isSupportedType(currentTransfer)) {
                selectedElements = this.getSelectedElements();
            }
            IElement targetElement = null;
            if (target instanceof ModelElementAdapter) {
                ModelElementAdapter adapter = (ModelElementAdapter)target;
                targetElement = adapter.getElement();
            }
            if (selectedElements == null || targetElement == null) {
                return null;
            }
            ArrayList droppedElements = new ArrayList();
            droppedElements.addAll(selectedElements);
            IModelingSession modelingSession = Explorer.getInstance().getModelingSession();
            ITransactionManager transactionManager = modelingSession.getTransactionManager();
            ITransaction transaction = transactionManager.createTransaction(event.detail == 1 ? "Copy" : "Cut");
            try {
                try {
                    IStatus s1 = this.handleDropElements(droppedElements, targetElement, event);
                    if (Status.OK_STATUS.equals(s1)) {
                        transactionManager.commit(transaction);
                        transaction = null;
                        if (!selectedElements.isEmpty()) {
                            IElement movedElement = (IElement)selectedElements.get(0);
                            if (movedElement instanceof INote) {
                                O.getDefault().getNavigateService().fireNavigate(movedElement);
                            } else {
                                UmlNavigatorView view = this.getUmlNavigatorView();
                                if (view != null) {
                                    view.setExpandedState(targetElement, true);
                                }
                            }
                        }
                        break block16;
                    }
                    transactionManager.rollback(transaction);
                    transaction = null;
                }
                catch (InvalidTransactionException e) {
                    transaction = null;
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                    }
                }
            }
            finally {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        return null;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        List selectedElements = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            selectedElements = this.getSelectedElements();
        }
        IElement targetElement = null;
        if (target instanceof ModelElementAdapter) {
            ModelElementAdapter adapter = (ModelElementAdapter)target;
            targetElement = adapter.getElement();
        }
        if (selectedElements == null || targetElement == null || selectedElements.size() == 0) {
            return Status.CANCEL_STATUS;
        }
        if (operation == 2) {
            int i = 0;
            while (i < selectedElements.size()) {
                if (((IElement)selectedElements.get(i)).equals((Object)targetElement) || this.isParentOf((IElement)selectedElements.get(i), targetElement)) {
                    return Status.CANCEL_STATUS;
                }
                ++i;
            }
        }
        boolean selectionAreFreeCmsNode = true;
        for (IElement element : selectedElements) {
            boolean isFreeCmsNode;
            IElementStatus status = element.getElementStatus();
            boolean bl = isFreeCmsNode = status.isCmsNode() && !status.isCmsManaged();
            if (selectionAreFreeCmsNode && !isFreeCmsNode) {
                selectionAreFreeCmsNode = false;
            }
            String dep = null;
            if (element instanceof IAssociation || element instanceof ILink) {
                return Status.CANCEL_STATUS;
            }
            if (element instanceof IParameter) {
                IOperation targetOperation;
                IParameter parameter = (IParameter)element;
                if (targetElement instanceof IOperation && parameter.getReturned() != null && (targetOperation = (IOperation)targetElement).getReturn() != null) {
                    return Status.CANCEL_STATUS;
                }
            } else if (element instanceof IClassAssociation) {
                IAssociation targetAssociation;
                if (targetElement instanceof IAssociation && (targetAssociation = (IAssociation)targetElement).getLinkToClass() != null) {
                    return Status.CANCEL_STATUS;
                }
            } else {
                if (element instanceof IModule) {
                    return Status.CANCEL_STATUS;
                }
                dep = CompositionExpert.getDefaultCompositionDep((IElement)targetElement, (IElement)element);
                if (dep == null || dep.equals("")) {
                    return Status.CANCEL_STATUS;
                }
                if (!this.canBeParentOf(targetElement, element)) {
                    return Status.CANCEL_STATUS;
                }
            }
            if (operation != 2) continue;
            if (!status.isModifiable()) {
                return Status.CANCEL_STATUS;
            }
            IElement parentElement = element.getCompositionOwner();
            if (parentElement.getElementStatus().isModifiable() || isFreeCmsNode) continue;
            return Status.CANCEL_STATUS;
        }
        IElementStatus targetStatus = targetElement.getElementStatus();
        if (!targetStatus.isModifiable() && !selectionAreFreeCmsNode) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected UmlNavigatorView getUmlNavigatorView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof UmlNavigatorView) {
            return (UmlNavigatorView)activePart;
        }
        return null;
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object o : structuredSelection) {
                IAdaptable adapter;
                IElement element;
                if (!(o instanceof IAdaptable) || (element = (IElement)(adapter = (IAdaptable)o).getAdapter(IElement.class)) == null) continue;
                selectedElements.add(element);
            }
        }
        return selectedElements;
    }

    private boolean isParentOf(IElement parentCandidate, IElement element) {
        IElement parent = element.getCompositionOwner();
        if (parent == null) {
            return false;
        }
        if (parentCandidate.equals((Object)parent)) {
            return true;
        }
        return this.isParentOf(parentCandidate, parent);
    }

    private boolean canBeParentOf(IElement parent, IElement child) {
        ICreationExpert expert;
        if (parent instanceof IModelElement) {
            IModelElement p = (IModelElement)parent;
            for (IStereotype s : p.getExtension()) {
                ICreationExpert expert2 = CreationExpertRegistry.getExpert((IStereotype)s);
                if (expert2 == null || expert2.canOwn(parent, child, null) || expert2.canLinkFrom(parent, null)) continue;
                return false;
            }
        }
        if ((expert = CreationExpertRegistry.getExpert(parent.getClass())).canOwn(parent, child, null)) {
            return true;
        }
        return expert.canLinkFrom(parent, null);
    }

    private IStatus handleDropElements(ArrayList<IElement> droppedElements, IElement targetElement, DropTargetEvent event) {
        if (droppedElements.size() == 0) {
            return Status.OK_STATUS;
        }
        if (event.detail == 1) {
            List copyResult = null;
            try {
                copyResult = ModelServices.copyTo((Collection)new ObList(droppedElements), (IElement)targetElement);
            }
            catch (Exception e) {
                MessageDialog.openError(null, (String)Messages.getMessage((String)"CopyFailed", (String[])new String[0]), (String)e.getLocalizedMessage());
                if (!(e instanceof InvalidModelManipulationException)) {
                    e.printStackTrace();
                }
                return null;
            }
            if (copyResult != null && copyResult.size() >= 1) {
                IElement copiedElement = (IElement)copyResult.get(0);
                if (copiedElement instanceof INote) {
                    O.getDefault().getNavigateService().fireNavigate(copiedElement);
                } else {
                    UmlNavigatorView view = this.getUmlNavigatorView();
                    if (view != null) {
                        view.setExpandedState(targetElement, true);
                    }
                }
            }
        } else if (event.detail == 2) {
            int i = 0;
            while (i < droppedElements.size()) {
                if (droppedElements.get(i).equals((Object)targetElement) || this.isParentOf(droppedElements.get(i), targetElement)) {
                    return null;
                }
                ++i;
            }
            try {
                ModelServices.moveTo((Collection)new ObList(droppedElements), (IElement)targetElement);
            }
            catch (Exception e) {
                MessageDialog.openError(null, (String)Messages.getMessage((String)"MovingFailed", (String[])new String[0]), (String)e.getLocalizedMessage());
                if (!(e instanceof InvalidModelManipulationException)) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return Status.OK_STATUS;
    }
}

