/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IClassAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.explorer.commands.CreateSiblingElementServices;
import com.modeliosoft.modelio.explorer.model.DependencyContainerAdapter;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.explorer.plugin.Explorer;
import com.modeliosoft.modelio.explorer.views.UmlNavigatorView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateSiblingElementHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        UmlNavigatorView view;
        IElement lastCreatedElement;
        block13: {
            List selectedElements = this.getSelectedElements();
            IElement parentElement = this.getCommonParent(selectedElements);
            if (parentElement == null) {
                return null;
            }
            IModelingSession modelingSession = Explorer.getInstance().getModelingSession();
            ITransactionManager transactionManager = modelingSession.getTransactionManager();
            ITransaction transaction = transactionManager.createTransaction("Create a Sibling");
            lastCreatedElement = null;
            try {
                for (IElement selectedElement : selectedElements) {
                    lastCreatedElement = CreateSiblingElementServices.createSibling((IElement)parentElement, (IElement)selectedElement);
                }
                transactionManager.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                lastCreatedElement = null;
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                    lastCreatedElement = null;
                }
                break block13;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                        lastCreatedElement = null;
                    }
                }
            }
            if (transaction == null) break block13;
            transactionManager.rollback(transaction);
            lastCreatedElement = null;
        }
        if ((view = this.getUmlNavigatorView()) != null && lastCreatedElement != null) {
            view.selectElement(lastCreatedElement);
            ModelElementAdapter adapter = view.getContentProvider().getAdaptersCache().getAdapter(lastCreatedElement);
            if (adapter != null) {
                view.getCommonViewer().editElement((Object)adapter, 0);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        if (this.selectionContainsFakeAdapter()) {
            return false;
        }
        List selectedElements = this.getSelectedElements();
        IElement parentElement = this.getCommonParent(selectedElements);
        if (parentElement == null) {
            return false;
        }
        boolean selectedElementAreCmsNodes = true;
        boolean selectedElementContainsRamcObject = false;
        for (IElement selectedElement : selectedElements) {
            IParameter selectedParameter;
            IElementStatus selectedElementStatus = selectedElement.getElementStatus();
            if (!selectedElementStatus.isCmsNode()) {
                selectedElementAreCmsNodes = false;
            }
            if (selectedElementStatus.isRamcObject()) {
                selectedElementContainsRamcObject = true;
            }
            if (selectedElement instanceof IAssociation || selectedElement instanceof ILink) {
                return false;
            }
            if (selectedElement instanceof IClassAssociation) {
                return false;
            }
            if (!(selectedElement instanceof IParameter) || (selectedParameter = (IParameter)selectedElement).getReturned() == null) continue;
            return false;
        }
        IElementStatus parentStatus = parentElement.getElementStatus();
        return (parentStatus.isModifiable() || selectedElementAreCmsNodes) && !parentStatus.isRamcObject() && !selectedElementContainsRamcObject;
    }

    private List<IElement> getSelectedElements() {
        UmlNavigatorView view = this.getUmlNavigatorView();
        ISelection selection = view.getCommonViewer().getSelection();
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }

    private IElement getCommonParent(List<IElement> selectedElements) {
        IElement parentElement = null;
        IElement currentParentElement = null;
        for (IElement element : selectedElements) {
            currentParentElement = element.getCompositionOwner();
            if (currentParentElement == null) {
                return null;
            }
            if (parentElement == null) {
                parentElement = currentParentElement;
                continue;
            }
            if (parentElement.equals((Object)currentParentElement)) continue;
            return null;
        }
        return parentElement;
    }

    private UmlNavigatorView getUmlNavigatorView() {
        IViewReference[] viewRefs;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IViewReference[] iViewReferenceArray = viewRefs = page.getViewReferences();
        int n = viewRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewRef = iViewReferenceArray[n2];
            if (viewRef.getId().equals("com.modeliosoft.modelio.explorer.UmlNavigatorContentID")) {
                return (UmlNavigatorView)viewRef.getView(false);
            }
            ++n2;
        }
        return null;
    }

    private boolean selectionContainsFakeAdapter() {
        UmlNavigatorView view = this.getUmlNavigatorView();
        if (view == null) {
            return true;
        }
        ISelection selection = view.getCommonViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                if (!(obj instanceof DependencyContainerAdapter)) continue;
                return true;
            }
        }
        return false;
    }
}

