/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.CompositionServices;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.explorer.plugin.Explorer;
import com.modeliosoft.modelio.explorer.views.UmlNavigatorView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MoveElementUpHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<IElement> listToReorder = new ArrayList<IElement>();
        List selectedElements = this.getSelectedElements();
        IElement parentElement = this.getCommonParent(selectedElements);
        int nbToMove = 0;
        String depName = "";
        if (parentElement != null) {
            for (IElement element : selectedElements) {
                depName = CompositionServices.getCompositionParentDep((IElement)element);
                ObList contentsToReorder = new Meta(parentElement).getDependencyElements(depName);
                for (IElement content : contentsToReorder) {
                    listToReorder.add(content);
                }
                int index = this.getIndexUp(element, listToReorder);
                if (index == -1) break;
                ++nbToMove;
                listToReorder.remove(element);
                listToReorder.add(index, element);
            }
            if (nbToMove > 0) {
                IModelingSession modelingSession = Explorer.getInstance().getModelingSession();
                ITransactionManager transactionManager = modelingSession.getTransactionManager();
                ITransaction transaction = transactionManager.createTransaction("MoveUp");
                try {
                    try {
                        ModelServices.reorderDep((IElement)parentElement, (String)depName, listToReorder);
                        transactionManager.commit(transaction);
                        transaction = null;
                    }
                    catch (InvalidModelManipulationException e) {
                        transaction = null;
                        if (transaction != null) {
                            transactionManager.rollback(transaction);
                        }
                    }
                }
                finally {
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                    }
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        List selectedElements = this.getSelectedElements();
        IElement parentElement = this.getCommonParent(selectedElements);
        if (parentElement == null) {
            return false;
        }
        IElementStatus parentStatus = parentElement.getElementStatus();
        return parentStatus.isModifiable();
    }

    public boolean isHandled() {
        return true;
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        UmlNavigatorView view = this.getUmlNavigatorView();
        if (view == null) {
            return selectedElements;
        }
        ISelection selection = view.getCommonViewer().getSelection();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }

    private IElement getCommonParent(List<IElement> selectedElements) {
        IElement parentElement = null;
        IElement currentParentElement = null;
        for (IElement element : selectedElements) {
            currentParentElement = element.getCompositionOwner();
            if (currentParentElement == null) {
                return null;
            }
            if (parentElement == null) {
                parentElement = currentParentElement;
                continue;
            }
            if (parentElement.equals((Object)currentParentElement)) continue;
            return null;
        }
        return parentElement;
    }

    private int getIndexUp(IElement element, List<IElement> listToReorder) {
        int index = listToReorder.indexOf(element);
        if (index < 1) {
            return -1;
        }
        --index;
        while (index != -1 && listToReorder.get(index).getClass() != element.getClass()) {
            --index;
        }
        return index;
    }

    private UmlNavigatorView getUmlNavigatorView() {
        IViewReference[] viewRefs;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IViewReference[] iViewReferenceArray = viewRefs = page.getViewReferences();
        int n = viewRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewRef = iViewReferenceArray[n2];
            if (viewRef.getId().equals("com.modeliosoft.modelio.explorer.UmlNavigatorContentID")) {
                return (UmlNavigatorView)viewRef.getView(false);
            }
            ++n2;
        }
        return null;
    }
}

