/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.model;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.explorer.model.DependencyContainerAdapter;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapterCache;
import com.modeliosoft.modelio.explorer.model.UmlExplorerAdapter;
import com.modeliosoft.modelio.explorer.model.UmlExplorerCardVisitor;
import com.modeliosoft.modelio.explorer.model.UmlExplorerContentVisitor;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class UmlContentProvider
implements ITreeContentProvider {
    private final UmlExplorerContentVisitor modelVisitor = new UmlExplorerContentVisitor();
    private final ModelElementAdapterCache adaptersCache;
    private final UmlExplorerCardVisitor cardVisitor = new UmlExplorerCardVisitor();

    public UmlContentProvider() {
        this.adaptersCache = new ModelElementAdapterCache();
    }

    public void dispose() {
    }

    public ModelElementAdapterCache getAdaptersCache() {
        return this.adaptersCache;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ModelElementAdapter) {
            ModelElementAdapter parentAdapter = (ModelElementAdapter)parent;
            return this.getModelElementChildren(parentAdapter);
        }
        if (parent instanceof DependencyContainerAdapter) {
            DependencyContainerAdapter parentAdapter = (DependencyContainerAdapter)parent;
            return this.getDependencyContainerChildren(parentAdapter);
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof UmlExplorerAdapter) {
            UmlExplorerAdapter rootAdapter = (UmlExplorerAdapter)inputElement;
            List children = rootAdapter.getChildrenAdapters();
            for (UmlExplorerAdapter child : children) {
                ModelElementAdapter childModelElement;
                IElement element;
                if (!(child instanceof ModelElementAdapter) || (element = (childModelElement = (ModelElementAdapter)child).getElement()) == null || this.adaptersCache.getAdapter(element) != null) continue;
                this.adaptersCache.addAdapter(element, childModelElement);
            }
            return children.toArray(new Object[children.size()]);
        }
        return new Object[0];
    }

    public Object getParent(Object child) {
        if (child instanceof UmlExplorerAdapter) {
            UmlExplorerAdapter childAdapter = (UmlExplorerAdapter)child;
            return childAdapter.getParentAdapter();
        }
        return null;
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof ModelElementAdapter) {
            int childrenNumber = 0;
            ModelElementAdapter parentAdapter = (ModelElementAdapter)parent;
            IElement parentElement = parentAdapter.getElement();
            if (parentElement != null) {
                childrenNumber = this.cardVisitor.getAllCard(parentElement);
            }
            return childrenNumber > 0;
        }
        return parent instanceof DependencyContainerAdapter;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.adaptersCache.clear();
    }

    private ModelElementAdapter getAdapter(List<UmlExplorerAdapter> childrenAdapters, IElement element) {
        for (UmlExplorerAdapter adapter : childrenAdapters) {
            ModelElementAdapter modelElementAdapter;
            if (!(adapter instanceof ModelElementAdapter) || !(modelElementAdapter = (ModelElementAdapter)adapter).getElement().equals((Object)element)) continue;
            return modelElementAdapter;
        }
        return null;
    }

    private Object[] getChildrenDependencyLinks(DependencyContainerAdapter parentAdapter, List<IElement> dependencyLinks) {
        int childrenNumber = dependencyLinks.size();
        Object[] children = new Object[childrenNumber];
        List childrenAdapters = parentAdapter.getChildrenAdapters();
        int i = 0;
        while (i < childrenNumber) {
            IElement element = dependencyLinks.get(i);
            ModelElementAdapter elementAdapter = this.getAdapter(childrenAdapters, element);
            if (elementAdapter == null) {
                elementAdapter = new ModelElementAdapter(element, (UmlExplorerAdapter)parentAdapter);
                childrenAdapters.add(elementAdapter);
                this.adaptersCache.addAdapter(element, elementAdapter);
            }
            children[i] = elementAdapter;
            ++i;
        }
        return children;
    }

    private Object[] assembleChildren(ModelElementAdapter parentAdapter, List<IElement> directChildren, List<IElement> auxiliaryChildren) {
        int nObjects = directChildren.size() + (auxiliaryChildren.size() > 0 ? 1 : 0);
        Object[] children = new Object[nObjects];
        List childrenAdapters = parentAdapter.getChildrenAdapters();
        int index = 0;
        for (IElement directChild : directChildren) {
            ModelElementAdapter elementAdapter = this.getAdapter(childrenAdapters, directChild);
            if (elementAdapter == null) {
                elementAdapter = new ModelElementAdapter(directChild, (UmlExplorerAdapter)parentAdapter);
                childrenAdapters.add(elementAdapter);
                this.adaptersCache.addAdapter(directChild, elementAdapter);
            }
            children[index] = elementAdapter;
            ++index;
        }
        if (auxiliaryChildren.size() > 0) {
            DependencyContainerAdapter dependencyAdapter = parentAdapter.getDependencyAdapter();
            if (dependencyAdapter == null) {
                dependencyAdapter = new DependencyContainerAdapter((UmlExplorerAdapter)parentAdapter);
                parentAdapter.setDependencyAdapter(dependencyAdapter);
            }
            children[index] = dependencyAdapter;
            ++index;
        }
        return children;
    }

    private Object[] getDependencyContainerChildren(DependencyContainerAdapter parentAdapter) {
        UmlExplorerAdapter realParentAdapter = parentAdapter.getParentAdapter();
        if (realParentAdapter instanceof ModelElementAdapter) {
            ModelElementAdapter elementAdapter = (ModelElementAdapter)realParentAdapter;
            IElement parentElement = elementAdapter.getElement();
            List auxiliaryChildren = this.modelVisitor.getAuxiliaryChildren(parentElement);
            return this.getChildrenDependencyLinks(parentAdapter, auxiliaryChildren);
        }
        return new Object[0];
    }

    private Object[] getModelElementChildren(ModelElementAdapter parentAdapter) {
        IElement parentElement = parentAdapter.getElement();
        if (parentElement != null) {
            List umlChildren = this.modelVisitor.getUmlChildren(parentElement);
            List auxiliaryChildren = this.modelVisitor.getAuxiliaryChildren(parentElement);
            Object[] children = this.assembleChildren(parentAdapter, umlChildren, auxiliaryChildren);
            return children;
        }
        return new Object[0];
    }
}

