/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.diagrams.IActivityDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivity;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityParameterNode;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IInstanceNode;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehaviorParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCase;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.explorer.popup.handlers.CreateCmsElementHandler;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;

public class CreateActivityHandler
extends CreateCmsElementHandler {
    public IElement create(IElement selectedElement, IModelingSession modellingSession) throws ExecutionException {
        IActivity activity = (IActivity)modellingSession.getModelFactory().createElement(this.metaclass, selectedElement, this.dependency);
        if (this.stereotype != null) {
            try {
                IStereotype obstereotype = modellingSession.getModel().getProject().getStereotype(activity.getClass(), this.stereotype);
                activity.addExtension(obstereotype);
            }
            catch (StereotypeNotFoundException e) {
                throw new ExecutionException("Could not create element", (Throwable)e);
            }
        }
        DefaultNameFactory.setDefaultName((IModelElement)activity);
        if (selectedElement instanceof IClassifier && !(selectedElement instanceof IUseCase)) {
            this.smartCreateForClassifier(modellingSession, activity, (IClassifier)selectedElement);
        } else if (selectedElement instanceof IOperation) {
            this.smartCreateForOperation(modellingSession, activity, (IOperation)selectedElement);
        } else {
            this.smartCreateForNameSpace(modellingSession, activity);
        }
        return activity;
    }

    private void smartCreateForClassifier(IModelingSession modelingSession, IActivity activity, IClassifier parentClassifier) {
        String activityName = activity.getName();
        IActivityDiagram diagram = modelingSession.getModelFactory().createActivityDiagram("", (IModelElement)activity);
        if (diagram == null) {
            return;
        }
        diagram.setName(String.valueOf(activityName) + " diagram");
        diagram.setVertical(false);
        ICollaboration locals = (ICollaboration)modelingSession.getModelFactory().createElement("Collaboration", (IElement)activity, "OwnedCollaboration");
        if (locals == null) {
            return;
        }
        locals.setName("locals");
        IBindableInstance instance = (IBindableInstance)modelingSession.getModelFactory().createElement("BindableInstance", (IElement)locals, "Declared");
        if (instance == null) {
            return;
        }
        instance.setName("this");
        instance.setBase((INameSpace)parentClassifier);
        IInstanceNode instanceNode = (IInstanceNode)modelingSession.getModelFactory().createElement("InstanceNode", (IElement)activity, "OwnedNode");
        if (instanceNode == null) {
            return;
        }
        instanceNode.setName("this");
        instanceNode.setRepresented((IInstance)instance);
    }

    private void smartCreateForNameSpace(IModelingSession modelingSession, IActivity activity) {
        String activityName = activity.getName();
        IActivityDiagram diagram = modelingSession.getModelFactory().createActivityDiagram("", (IModelElement)activity);
        if (diagram == null) {
            return;
        }
        diagram.setName(String.valueOf(activityName) + " diagram");
        diagram.setVertical(false);
        ICollaboration locals = (ICollaboration)modelingSession.getModelFactory().createElement("Collaboration", (IElement)activity, "OwnedCollaboration");
        if (locals == null) {
            return;
        }
        locals.setName("locals");
    }

    private void smartCreateForOperation(IModelingSession modelingSession, IActivity activity, IOperation parentOperation) {
        String parameterName;
        String activityName = activity.getName();
        IActivityDiagram diagram = modelingSession.getModelFactory().createActivityDiagram("", (IModelElement)activity);
        if (diagram == null) {
            return;
        }
        diagram.setName(String.valueOf(activityName) + " diagram");
        diagram.setVertical(false);
        ICollaboration locals = (ICollaboration)modelingSession.getModelFactory().createElement("Collaboration", (IElement)activity, "OwnedCollaboration");
        if (locals == null) {
            return;
        }
        locals.setName("locals");
        IBindableInstance instance = (IBindableInstance)modelingSession.getModelFactory().createElement("BindableInstance", (IElement)locals, "Declared");
        if (instance == null) {
            return;
        }
        instance.setName("this");
        instance.setBase((INameSpace)parentOperation.getOwner());
        IInstanceNode instanceNode = (IInstanceNode)modelingSession.getModelFactory().createElement("InstanceNode", (IElement)activity, "OwnedNode");
        if (instanceNode == null) {
            return;
        }
        instanceNode.setName("this");
        instanceNode.setRepresented((IInstance)instance);
        ObList paramsList = parentOperation.getIO();
        IBehaviorParameter behaviorParameter = null;
        IActivityParameterNode parameterNode = null;
        for (IParameter parameter : paramsList) {
            behaviorParameter = (IBehaviorParameter)modelingSession.getModelFactory().createElement("BehaviorParameter", (IElement)activity, "Parameter");
            parameterName = parameter.getName();
            if (behaviorParameter == null) continue;
            behaviorParameter.setName(parameterName);
            behaviorParameter.setMultiplicityMin(parameter.getMultiplicityMin());
            behaviorParameter.setMultiplicityMax(parameter.getMultiplicityMax());
            behaviorParameter.setParameterPassing(parameter.getParameterPassing());
            behaviorParameter.setTypeConstraint(parameter.getTypeConstraint());
            behaviorParameter.setDefaultValue(parameter.getDefaultValue());
            behaviorParameter.setMapped(parameter);
            behaviorParameter.setType(parameter.getType());
            parameterNode = (IActivityParameterNode)modelingSession.getModelFactory().createElement("ActivityParameterNode", (IElement)activity, "OwnedNode");
            if (parameterNode == null) continue;
            parameterNode.setRepresentedRealParameter(behaviorParameter);
            parameterNode.setName(parameterName);
        }
        IParameter returnParameter = parentOperation.getReturn();
        if (returnParameter != null) {
            behaviorParameter = (IBehaviorParameter)modelingSession.getModelFactory().createElement("BehaviorParameter", (IElement)activity, "Parameter");
            parameterName = returnParameter.getName();
            if (behaviorParameter != null) {
                behaviorParameter.setName(parameterName);
                behaviorParameter.setMultiplicityMin(returnParameter.getMultiplicityMin());
                behaviorParameter.setMultiplicityMax(returnParameter.getMultiplicityMax());
                behaviorParameter.setParameterPassing(returnParameter.getParameterPassing());
                behaviorParameter.setTypeConstraint(returnParameter.getTypeConstraint());
                behaviorParameter.setDefaultValue(returnParameter.getDefaultValue());
                behaviorParameter.setMapped(returnParameter);
                behaviorParameter.setType(returnParameter.getType());
                parameterNode = (IActivityParameterNode)modelingSession.getModelFactory().createElement("ActivityParameterNode", (IElement)activity, "OwnedNode");
                if (parameterNode != null) {
                    parameterNode.setRepresentedRealParameter(behaviorParameter);
                    parameterNode.setName(parameterName);
                }
            }
        }
    }

    protected void postCommit(IElement element) {
        IActivityDiagram param = (IActivityDiagram)((IActivity)element).getproduct(IActivityDiagram.class).get(0);
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        super.postCommit(element);
    }
}

