/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.BasicElementInitializer;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.explorer.popup.handlers.AbstractExplorerCreateHandler;
import org.eclipse.core.commands.ExecutionException;

public class CreateAssociationHandler
extends AbstractExplorerCreateHandler {
    public IElement create(IElement selectedElement, IModelingSession modellingSession) throws ExecutionException {
        IClassifier parentClassifier = (IClassifier)selectedElement;
        String dependencyName = parentClassifier.getName();
        dependencyName = dependencyName.length() > 0 ? String.valueOf(dependencyName.substring(0, 1).toLowerCase()) + dependencyName.substring(1) : "";
        IAssociation association = modellingSession.getModelFactory().createAssociation(parentClassifier, parentClassifier, dependencyName);
        if (this.stereotype != null) {
            try {
                IStereotype obstereotype = modellingSession.getModel().getProject().getStereotype(association.getClass(), this.stereotype);
                association.addExtension(obstereotype);
            }
            catch (StereotypeNotFoundException e) {
                throw new ExecutionException("Could not create element", (Throwable)e);
            }
        }
        DefaultNameFactory.setDefaultName((IModelElement)association);
        IAssociationEnd navigableEnd = (IAssociationEnd)association.getConnection().get(0);
        if (!navigableEnd.isNavigable()) {
            navigableEnd = (IAssociationEnd)association.getConnection().get(1);
        }
        BasicElementInitializer initializer = new BasicElementInitializer(O.getDefault().getModelingSession());
        initializer.initialize((IElement)navigableEnd);
        return navigableEnd;
    }
}

