/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IDataType;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.ObVisibilityModeEnum;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.explorer.popup.handlers.AbstractExplorerCreateHandler;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;

public class CreateAttributeHandler
extends AbstractExplorerCreateHandler {
    public IElement create(IElement selectedElement, IModelingSession modellingSession) throws ExecutionException {
        IAttribute attribute = (IAttribute)modellingSession.getModelFactory().createElement(this.metaclass, selectedElement, this.dependency);
        ObVisibilityModeEnum defaultVisibility = ObVisibilityModeEnum.valueOf((String)modellingSession.getProjectPropertiesService().readProperty("Modelio", "Preferences.Attribute.DefaultVisibility"));
        String defaultType = modellingSession.getProjectPropertiesService().readProperty("Modelio", "Preferences.Attribute.DefaultType");
        if (defaultType == null || defaultType.isEmpty()) {
            defaultType = "string";
        }
        attribute.setVisibility(defaultVisibility);
        IDataType type = this.getType(modellingSession, defaultType);
        attribute.setType((IGeneralClass)type);
        if (this.stereotype != null) {
            try {
                IStereotype obstereotype = modellingSession.getModel().getProject().getStereotype(attribute.getClass(), this.stereotype);
                attribute.addExtension(obstereotype);
            }
            catch (StereotypeNotFoundException e) {
                throw new ExecutionException("Could not create element", (Throwable)e);
            }
        }
        DefaultNameFactory.setDefaultName((IModelElement)attribute);
        return attribute;
    }

    private IDataType getType(IModelingSession modelingSession, String type) {
        List list = modelingSession.getModel().findByAtt(IDataType.class, "Name", type);
        if (list.size() > 0) {
            for (IElement element : list) {
                IDataType dataType = (IDataType)element;
                IModelTree owner = dataType.getOwner();
                if (owner == null || !owner.getName().equals("_S_PredefinedTypes")) continue;
                return dataType;
            }
        }
        return null;
    }
}

