/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnActivity;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnBoundaryEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcess;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapterCache;
import com.modeliosoft.modelio.explorer.popup.handlers.AbstractExplorerCreateHandler;
import com.modeliosoft.modelio.explorer.views.UmlNavigatorView;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.navigator.CommonViewer;

public class CreateBpmnBoundaryEventHandler
extends AbstractExplorerCreateHandler {
    protected IElement create(IElement selectedElement, IModelingSession modelingSession) throws ExecutionException {
        IElement owner = this.getOwnerProcess(selectedElement.getCompositionOwner());
        IBpmnBoundaryEvent element = (IBpmnBoundaryEvent)modelingSession.getModelFactory().createElement(this.metaclass, owner, this.dependency);
        element.setCancelActivity(true);
        DefaultNameFactory.setDefaultName((IModelElement)element);
        element.setAttachedToRef((IBpmnActivity)selectedElement);
        return element;
    }

    private IElement getOwnerProcess(IElement element) {
        if (element instanceof IBpmnProcess || element instanceof IBpmnSubProcess) {
            return element;
        }
        return this.getOwnerProcess(element.getCompositionOwner());
    }

    protected void postCommit(IElement element) {
        IBpmnBoundaryEvent boundaryevent = (IBpmnBoundaryEvent)element;
        IBpmnActivity owner = boundaryevent.getAttachedToRef();
        if (owner != null) {
            UmlNavigatorView view = this.getActiveUmlNavigatorView();
            CommonViewer viewer = view.getCommonViewer();
            ModelElementAdapterCache adaptersCache = view.getContentProvider().getAdaptersCache();
            ModelElementAdapter adapter = adaptersCache.getAdapter((IElement)owner);
            if (adapter != null) {
                viewer.setExpandedState((Object)adapter, true);
            }
        }
        super.postCommit(element);
    }
}

