/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnActivity;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapterCache;
import com.modeliosoft.modelio.explorer.popup.handlers.AbstractExplorerCreateHandler;
import com.modeliosoft.modelio.explorer.views.UmlNavigatorView;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.navigator.CommonViewer;

public class CreateBpmnFlowElementHandler
extends AbstractExplorerCreateHandler {
    protected IElement create(IElement selectedElement, IModelingSession modelingSession) throws ExecutionException {
        IElement owner = this.getOwnerProcess(selectedElement);
        IBpmnFlowElement element = (IBpmnFlowElement)modelingSession.getModelFactory().createElement(this.metaclass, owner, this.dependency);
        DefaultNameFactory.setDefaultName((IModelElement)element);
        if (selectedElement instanceof IBpmnLane) {
            element.addLane((IBpmnLane)selectedElement);
        }
        return element;
    }

    private IElement getOwnerProcess(IElement element) {
        if (element instanceof IBpmnProcess || element instanceof IBpmnActivity) {
            return element;
        }
        return this.getOwnerProcess(element.getCompositionOwner());
    }

    public boolean isEnabled() {
        if (super.isEnabled()) {
            IElement selection = this.getSelectedElement();
            if (selection instanceof IBpmnLane) {
                return ((IBpmnLane)selection).getChildLaneSet() == null;
            }
            return true;
        }
        return false;
    }

    protected void postCommit(IElement element) {
        IBpmnFlowElement flowelement = (IBpmnFlowElement)element;
        if (flowelement.cardLane() > 0) {
            UmlNavigatorView view = this.getActiveUmlNavigatorView();
            CommonViewer viewer = view.getCommonViewer();
            ModelElementAdapterCache adaptersCache = view.getContentProvider().getAdaptersCache();
            ModelElementAdapter adapter = adaptersCache.getAdapter((IElement)flowelement.getLane().get(0));
            if (adapter != null) {
                viewer.setExpandedState((Object)adapter, true);
            }
        }
        super.postCommit(element);
    }
}

