/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLaneSet;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.explorer.popup.handlers.AbstractExplorerCreateHandler;
import org.eclipse.core.commands.ExecutionException;

public class CreateBpmnLaneHandler
extends AbstractExplorerCreateHandler {
    protected IElement create(IElement selectedElement, IModelingSession modelingSession) throws ExecutionException {
        IBpmnLane lane = (IBpmnLane)selectedElement;
        IBpmnLaneSet laneSet = lane.getChildLaneSet();
        if (laneSet == null) {
            IModelFactory modelFactory = modelingSession.getModelFactory();
            laneSet = (IBpmnLaneSet)modelFactory.createElement("BpmnLaneSet");
            laneSet.setParentLane((IBpmnLane)selectedElement);
            DefaultNameFactory.setDefaultName((IModelElement)laneSet);
        }
        return this.createLane(laneSet, modelingSession);
    }

    private IBpmnLane createLane(IBpmnLaneSet owner, IModelingSession modelingSession) {
        IModelFactory modelFactory = modelingSession.getModelFactory();
        IBpmnLane newElement = (IBpmnLane)modelFactory.createElement("BpmnLane");
        newElement.setLaneSet(owner);
        DefaultNameFactory.setDefaultName((IModelElement)newElement);
        return newElement;
    }

    public boolean isEnabled() {
        IElement selection;
        if (super.isEnabled() && (selection = this.getSelectedElement()) instanceof IBpmnLane) {
            return ((IBpmnLane)selection).cardFlowElementRef() == 0;
        }
        return false;
    }

    protected void postCommit(IElement element) {
    }
}

