/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.ICommunicationDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.communication.ICommunicationInteraction;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCase;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.explorer.popup.handlers.CreateCmsElementHandler;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;

public class CreateCommunicationInteractionHandler
extends CreateCmsElementHandler {
    public IElement create(IElement selectedElement, IModelingSession modellingSession) throws ExecutionException {
        ICommunicationInteraction communication = (ICommunicationInteraction)modellingSession.getModelFactory().createElement(this.metaclass, selectedElement, this.dependency);
        if (this.stereotype != null) {
            try {
                IStereotype obstereotype = modellingSession.getModel().getProject().getStereotype(communication.getClass(), this.stereotype);
                communication.addExtension(obstereotype);
            }
            catch (StereotypeNotFoundException e) {
                throw new ExecutionException("Could not create element", (Throwable)e);
            }
        }
        DefaultNameFactory.setDefaultName((IModelElement)communication);
        if (selectedElement instanceof IClassifier && !(selectedElement instanceof IUseCase)) {
            this.smartCreateForClassifier(modellingSession, communication);
        } else if (selectedElement instanceof IOperation) {
            this.smartCreateForOperation(modellingSession, communication);
        } else {
            this.smartCreateForNameSpace(modellingSession, communication);
        }
        return communication;
    }

    private void smartCreateForClassifier(IModelingSession modelingSession, ICommunicationInteraction communication) throws ExecutionException {
        ICommunicationDiagram diagram = null;
        try {
            diagram = modelingSession.getModelFactory().createCommunicationDiagram("", (IModelElement)communication, null);
        }
        catch (StereotypeNotFoundException e) {
            throw new ExecutionException("Could not create element", (Throwable)e);
        }
        DefaultNameFactory.setDefaultName((IAbstractDiagram)diagram);
        ICollaboration locals = (ICollaboration)modelingSession.getModelFactory().createElement("Collaboration", (IElement)communication, "OwnedCollaboration");
        if (locals == null) {
            return;
        }
        locals.setName("locals");
    }

    private void smartCreateForNameSpace(IModelingSession modelingSession, ICommunicationInteraction communication) throws ExecutionException {
        ICommunicationDiagram diagram = null;
        try {
            diagram = modelingSession.getModelFactory().createCommunicationDiagram("", (IModelElement)communication, null);
        }
        catch (StereotypeNotFoundException e) {
            throw new ExecutionException("Could not create element", (Throwable)e);
        }
        DefaultNameFactory.setDefaultName((IAbstractDiagram)diagram);
        ICollaboration locals = (ICollaboration)modelingSession.getModelFactory().createElement("Collaboration", (IElement)communication, "OwnedCollaboration");
        if (locals == null) {
            return;
        }
        locals.setName("locals");
    }

    private void smartCreateForOperation(IModelingSession modelingSession, ICommunicationInteraction communication) throws ExecutionException {
        ICommunicationDiagram diagram = null;
        try {
            diagram = modelingSession.getModelFactory().createCommunicationDiagram("", (IModelElement)communication, null);
        }
        catch (StereotypeNotFoundException e) {
            throw new ExecutionException("Could not create element", (Throwable)e);
        }
        DefaultNameFactory.setDefaultName((IAbstractDiagram)diagram);
        ICollaboration locals = (ICollaboration)modelingSession.getModelFactory().createElement("Collaboration", (IElement)communication, "OwnedCollaboration");
        if (locals == null) {
            return;
        }
        locals.setName("locals");
    }

    protected void postCommit(IElement element) {
        ObList diagram = ((ICommunicationInteraction)element).getproduct(ICommunicationDiagram.class);
        if (!diagram.isEmpty()) {
            ICommunicationDiagram param = (ICommunicationDiagram)diagram.get(0);
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        super.postCommit(element);
    }
}

