/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IDataType;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.explorer.popup.handlers.AbstractExplorerCreateHandler;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;

public class CreateIOParameterHandler
extends AbstractExplorerCreateHandler {
    public IElement create(IElement selectedElement, IModelingSession modellingSession) throws ExecutionException {
        IOperation operation = (IOperation)selectedElement;
        IParameter parameter = modellingSession.getModelFactory().createParameter();
        String defaultType = modellingSession.getProjectPropertiesService().readProperty("Modelio", "Preferences.IOParameter.DefaultType");
        if (defaultType == null || defaultType.equals("")) {
            defaultType = "string";
        }
        IDataType type = this.getType(modellingSession, defaultType);
        parameter.setType((IGeneralClass)type);
        operation.addIO(parameter);
        if (this.stereotype != null) {
            try {
                IStereotype obstereotype = modellingSession.getModel().getProject().getStereotype(parameter.getClass(), this.stereotype);
                parameter.addExtension(obstereotype);
            }
            catch (StereotypeNotFoundException e) {
                throw new ExecutionException("Could not create element", (Throwable)e);
            }
        }
        DefaultNameFactory.setDefaultName((IModelElement)parameter);
        return parameter;
    }

    private IDataType getType(IModelingSession modelingSession, String type) {
        List list = modelingSession.getModel().findByAtt(IDataType.class, "Name", type);
        if (list.size() > 0) {
            for (IElement element : list) {
                IDataType dataType = (IDataType)element;
                IModelTree owner = dataType.getOwner();
                if (owner == null || !owner.getName().equals("_S_PredefinedTypes")) continue;
                return dataType;
            }
        }
        return null;
    }
}

