/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.uml.behavior.state.IRegion;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.behavior.state.ObKindOfStateMachineEnum;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.explorer.popup.handlers.AbstractExplorerCreateHandler;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;

public class CreatePseudoStateHandler
extends AbstractExplorerCreateHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IElement create(IElement selectedElement, IModelingSession modellingSession) throws ExecutionException {
        IRegion parentState;
        if (selectedElement instanceof IStateMachine) {
            if (this.metaclass.equals("EntryPointPseudoState") || this.metaclass.equals("ExitPointPseudoState")) {
                parentState = (IStateMachine)selectedElement;
            } else {
                if (!(selectedElement instanceof IStateMachine) || ((IStateMachine)selectedElement).getTop() == null) throw new ExecutionException("Cannot create a pseudo state on " + String.valueOf(selectedElement));
                parentState = ((IStateMachine)selectedElement).getTop();
            }
        } else {
            if (!(selectedElement instanceof IRegion)) throw new ExecutionException("Cannot create a pseudo state on " + String.valueOf(selectedElement));
            parentState = (IRegion)selectedElement;
        }
        IModelElement modelElement = (IModelElement)modellingSession.getModelFactory().createElement(this.metaclass, (IElement)parentState, this.dependency);
        if (this.stereotype != null) {
            try {
                IStereotype obstereotype = modellingSession.getModel().getProject().getStereotype(modelElement.getClass(), this.stereotype);
                modelElement.addExtension(obstereotype);
            }
            catch (StereotypeNotFoundException e) {
                throw new ExecutionException("Could not create " + this.metaclass + " element: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        DefaultNameFactory.setDefaultName((IModelElement)modelElement);
        return modelElement;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (!(evaluationContext instanceof IEvaluationContext)) {
            return;
        }
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        IElement selectedElement = this.getSelectedElement();
        IStateMachine stateMachine = null;
        if (selectedElement instanceof IState) {
            stateMachine = this.getEnclosingStateMachine((IState)selectedElement);
        } else if (selectedElement instanceof IRegion) {
            stateMachine = this.getEnclosingStateMachine((IRegion)selectedElement);
        } else if (selectedElement instanceof IStateMachine) {
            stateMachine = (IStateMachine)selectedElement;
        }
        if (stateMachine != null && stateMachine.getKind() == ObKindOfStateMachineEnum.PROTOCOL) {
            String metaclassFromContext = (String)context.getVariable("metaclass");
            this.setBaseEnabled(!"EntryPointPseudoState".equals(metaclassFromContext) && !"ExitPointPseudoState".equals(metaclassFromContext) && !"ShallowHistoryPseudoState".equals(metaclassFromContext) && !"DeepHistoryPseudoState".equals(metaclassFromContext));
        }
    }

    private IStateMachine getEnclosingStateMachine(IState s) {
        IState state = s;
        IRegion region = null;
        while (state != null) {
            region = state.getParent();
            if (region.getRepresented() == null) {
                state = region.getParent();
                continue;
            }
            return region.getRepresented();
        }
        return null;
    }

    private IStateMachine getEnclosingStateMachine(IRegion region) {
        if (region.getRepresented() != null) {
            return region.getRepresented();
        }
        return this.getEnclosingStateMachine(region.getParent());
    }
}

