/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.popup.model;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.explorer.views.UmlNavigatorView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCreateAction
extends Action {
    protected String role;
    protected String stereotype;
    protected String targetClass;

    public AbstractCreateAction() {
    }

    public AbstractCreateAction(String text, int style) {
        super(text, style);
    }

    public abstract boolean accept(List<IElement> var1);

    public abstract void execute(List<IElement> var1);

    public String getRole() {
        return this.role;
    }

    public String getStereotype() {
        return this.stereotype;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public abstract boolean isActiveFor(List<IElement> var1);

    public void runWithEvent(Event event) {
        this.execute((List)this.getSelectedElements());
    }

    public final void setRole(String value) {
        this.role = value;
    }

    public void setStereotype(String value) {
        this.stereotype = value;
    }

    public void setTargetClass(String value) {
        this.targetClass = value;
    }

    protected UmlNavigatorView getActiveUmlNavigatorView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof UmlNavigatorView) {
            return (UmlNavigatorView)activePart;
        }
        return null;
    }

    private ArrayList<IElement> getSelectedElements() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }

    public boolean acceptAdaptables(List<IAdaptable> selectedAdaptables) {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        for (IAdaptable adaptable : selectedAdaptables) {
            IElement element = (IElement)adaptable.getAdapter(IElement.class);
            if (element == null) continue;
            selectedElements.add(element);
        }
        return this.accept(selectedElements);
    }

    public void executeAdaptables(List<IAdaptable> selectedAdaptables) {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        for (IAdaptable adaptable : selectedAdaptables) {
            IElement element = (IElement)adaptable.getAdapter(IElement.class);
            if (element == null) continue;
            selectedElements.add(element);
        }
        this.execute(selectedElements);
    }
}

