/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.views;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapter;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class ExplorerEditorActivationStrategy
extends ColumnViewerEditorActivationStrategy
implements MouseListener {
    private int time = 0;
    private IElement selectedElement = null;
    private ColumnViewer viewer;

    public ExplorerEditorActivationStrategy(ColumnViewer viewer) {
        super(viewer);
        this.viewer = viewer;
        viewer.getControl().addMouseListener((MouseListener)this);
    }

    protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
        if (event.eventType == 1 && event.keyCode == 0x100000B) {
            return true;
        }
        return event.eventType == 4;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        IElement sourceElement = null;
        Object eventSource = e.getSource();
        ModelElementAdapter adapter = null;
        if (eventSource instanceof Tree) {
            Tree tree = (Tree)eventSource;
            TreeItem clickedItem = tree.getItem(new Point(e.x, e.y));
            TreeItem[] items = tree.getSelection();
            if (items.length == 1 && clickedItem != null && items[0].getData() instanceof ModelElementAdapter) {
                adapter = (ModelElementAdapter)items[0].getData();
                sourceElement = adapter.getElement();
            }
        }
        if (sourceElement == null) {
            return;
        }
        boolean leftButtonClicked = false;
        if (e.button == 1) {
            leftButtonClicked = true;
        }
        if (this.time == 0 && leftButtonClicked) {
            this.time = e.time;
            this.selectedElement = sourceElement;
            return;
        }
        if (leftButtonClicked) {
            int delta = e.time - this.time;
            if (delta > 300 && delta < 1000 && this.selectedElement == sourceElement) {
                this.time = 0;
                this.selectedElement = sourceElement;
                this.viewer.editElement((Object)adapter, 0);
                return;
            }
            this.time = e.time;
            this.selectedElement = sourceElement;
            return;
        }
    }
}

