/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.views;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.IMetamodelVisitor;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.explorer.commands.CopyElementAction;
import com.modeliosoft.modelio.explorer.commands.CutElementAction;
import com.modeliosoft.modelio.explorer.commands.DeleteElementAction;
import com.modeliosoft.modelio.explorer.commands.OpenRelatedDiagramAction;
import com.modeliosoft.modelio.explorer.commands.PasteElementAction;
import com.modeliosoft.modelio.explorer.commands.RenameElementAction;
import com.modeliosoft.modelio.explorer.util.Messages;
import com.modeliosoft.modelio.explorer.views.UmlExplorerActionsManager;
import com.modeliosoft.modelio.explorer.views.UmlNavigatorView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;

class UmlExplorerActionsManager {
    private CopyElementAction copyElementAction;
    private CutElementAction cutElementAction;
    private DeleteElementAction deleteElementAction;
    private PasteElementAction pasteElementAction;
    private final UmlNavigatorView view;
    private boolean enableActions = true;
    private RenameElementAction renameElementAction;
    private final Clipboard clipboard;

    public UmlExplorerActionsManager(UmlNavigatorView view) {
        this.view = view;
        this.clipboard = new Clipboard(Display.getCurrent());
        this.makeActions();
    }

    protected void finalize() throws Throwable {
        this.clipboard.dispose();
        super.finalize();
    }

    public void fillContextMenu(IMenuManager manager, List<IElement> selectedElements) {
        manager.removeAll();
        manager.updateAll(true);
        if (this.enableActions) {
            this.fillStaticMenu(manager, selectedElements);
            this.fillRelatedDiagramMenu(manager, selectedElements);
        }
    }

    public void insertInSlot(IMenuManager menuManager, String slotName, IAction action) {
        MenuManager subMenu = (MenuManager)menuManager.find(slotName);
        if (subMenu == null) {
            subMenu = new MenuManager(slotName, slotName);
            menuManager.add((IContributionItem)subMenu);
        }
        subMenu.add(action);
    }

    protected void fillStaticMenu(IMenuManager manager, List<IElement> selectedElements) {
        manager.add((IContributionItem)new Separator("MdaMenu"));
        if (this.acceptsStaticMenu(selectedElements)) {
            manager.add((IContributionItem)new Separator("StaticMenu"));
            if (this.containsReadonlyElement(selectedElements)) {
                this.setModifyActionsEnabled(false);
            } else {
                this.setModifyActionsEnabled(true);
            }
            manager.add((IAction)this.cutElementAction);
            manager.add((IAction)this.copyElementAction);
            manager.add((IAction)this.pasteElementAction);
            manager.add((IAction)this.deleteElementAction);
            manager.add((IAction)this.renameElementAction);
            manager.add((IContributionItem)new Separator("audit"));
        }
    }

    private boolean containsReadonlyElement(List<IElement> selectedElements) {
        for (IElement element : selectedElements) {
            IElementStatus elementStatus = element.getElementStatus();
            if (elementStatus.isModifiable()) continue;
            return true;
        }
        return false;
    }

    private void makeActions() {
        ImageDescriptor desc;
        ImageDescriptor addStereotypeDesc;
        IHandlerService handlerService = null;
        handlerService = (IHandlerService)this.view.getSite().getService(IHandlerService.class);
        ImageDescriptor cutElementDesc = StandardImageService.getImageDescriptor((String)"core.element.cut");
        this.cutElementAction = new CutElementAction(Messages.getString((String)"Cut"), cutElementDesc, this.clipboard);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.explorer.CutElementCommandID", (IHandler)new ActionHandler((IAction)this.cutElementAction));
        }
        ImageDescriptor copyElementDesc = StandardImageService.getImageDescriptor((String)"core.element.copy");
        this.copyElementAction = new CopyElementAction(Messages.getString((String)"Copy"), copyElementDesc, this.clipboard);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.explorer.CopyElementCommandID", (IHandler)new ActionHandler((IAction)this.copyElementAction));
        }
        ImageDescriptor pasteElementDesc = StandardImageService.getImageDescriptor((String)"core.element.paste");
        this.pasteElementAction = new PasteElementAction(Messages.getString((String)"Paste"), pasteElementDesc, this.clipboard, this.view);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.explorer.PasteElementCommandID", (IHandler)new ActionHandler((IAction)this.pasteElementAction));
        }
        ImageDescriptor deleteElementDesc = StandardImageService.getImageDescriptor((String)"core.element.delete");
        this.deleteElementAction = new DeleteElementAction(Messages.getString((String)"Delete"), deleteElementDesc);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.explorer.DeleteElementCommandID", (IHandler)new ActionHandler((IAction)this.deleteElementAction));
        }
        ImageDescriptor renameElementDesc = StandardImageService.getImageDescriptor((String)"core.element.rename");
        this.renameElementAction = new RenameElementAction(Messages.getString((String)"Rename"), renameElementDesc);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.explorer.RenameElementCommandID", (IHandler)new ActionHandler((IAction)this.renameElementAction));
        }
        if ((addStereotypeDesc = StandardImageService.getImageDescriptor((String)"AddStereotype")) == null && (desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.explorer", (String)"icons/addStereotype_16.png")) != null) {
            StandardImageService.declareImage((String)"AddStereotype", (ImageDescriptor)desc);
            addStereotypeDesc = StandardImageService.getImageDescriptor((String)"AddStereotype");
        }
    }

    public void enableActions() {
        this.enableActions = true;
        this.copyElementAction.setEnabled(true);
        this.cutElementAction.setEnabled(true);
        this.deleteElementAction.setEnabled(true);
        this.pasteElementAction.setEnabled(true);
        this.renameElementAction.setEnabled(true);
    }

    public void disableActions() {
        this.enableActions = false;
        this.copyElementAction.setEnabled(false);
        this.cutElementAction.setEnabled(false);
        this.deleteElementAction.setEnabled(false);
        this.pasteElementAction.setEnabled(false);
        this.renameElementAction.setEnabled(false);
    }

    private boolean acceptsStaticMenu(List<IElement> selectedElements) {
        for (IElement element : selectedElements) {
            AcceptStaticEntriesVisitor visitor = new AcceptStaticEntriesVisitor(this);
            visitor.accepted = true;
            element.accept((IMetamodelVisitor)visitor);
            if (visitor.accepted) continue;
            return false;
        }
        return true;
    }

    public void setModifyActionsEnabled(boolean enable) {
        this.cutElementAction.setEnabled(enable);
        this.pasteElementAction.setEnabled(enable);
        this.deleteElementAction.setEnabled(enable);
        this.renameElementAction.setEnabled(enable);
    }

    private void fillRelatedDiagramMenu(IMenuManager manager, List<IElement> selectedElements) {
        if (selectedElements.size() != 1) {
            return;
        }
        IElement currentElement = selectedElements.get(0);
        if (!(currentElement instanceof IModelElement)) {
            return;
        }
        IModelElement currentModelElement = (IModelElement)currentElement;
        ObList dependencies = currentModelElement.getDependsOnDependency();
        ArrayList<IAbstractDiagram> relatedDiagrams = new ArrayList<IAbstractDiagram>();
        for (IDependency dependency : dependencies) {
            IModelElement relatedElement;
            if (!dependency.isStereotyped("related_diagram") || !((relatedElement = dependency.getDependsOn()) instanceof IAbstractDiagram)) continue;
            relatedDiagrams.add((IAbstractDiagram)relatedElement);
        }
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.explorer", (String)"icons/umldiagram.png");
        MenuManager subMenu = new MenuManager(Messages.getString((String)"related_diagram"), image, "related_diagram");
        manager.add((IContributionItem)subMenu);
        if (relatedDiagrams.size() > 0) {
            for (IAbstractDiagram relatedDiagram : relatedDiagrams) {
                ImageDescriptor desc = ImageDescriptor.createFromImage((Image)StandardImageService.getStereotypedImage((IElement)relatedDiagram, null));
                OpenRelatedDiagramAction openAction = new OpenRelatedDiagramAction(relatedDiagram.getName(), desc, relatedDiagram);
                subMenu.add((IAction)openAction);
            }
        }
    }
}

